/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;

public abstract class AbstractVertexRenderer<V, E>
implements Renderer.Vertex<V, E> {
    @Override
    public void paintVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        if (renderContext.getVertexIncludePredicate().test(v)) {
            this.paintIconForVertex(renderContext, layoutModel, v);
        }
    }

    protected abstract Shape getVertexShape(RenderContext<V, E> var1, V var2);

    protected Shape prepareFinalVertexShape(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v, int[] coords) {
        Shape shape = this.getVertexShape(renderContext, v);
        Point p = (Point)layoutModel.apply(v);
        Point2D p2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, p.x, p.y);
        float x = (float)p2d.getX();
        float y = (float)p2d.getY();
        coords[0] = (int)x;
        coords[1] = (int)y;
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        return xform.createTransformedShape(shape);
    }

    protected void paintShapeForVertex(RenderContext<V, E> renderContext, V v, Shape shape) {
        Stroke drawStroke;
        Paint drawPaint;
        Paint fillPaint;
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        MutableSelectedState<V> vertexSelectedState = renderContext.getSelectedVertexState();
        if (vertexSelectedState.isSelected(v)) {
            fillPaint = renderContext.getSelectedVertexFillPaintFunction().apply(v);
            drawPaint = renderContext.getSelectedVertexDrawPaintFunction().apply(v);
            drawStroke = renderContext.getSelectedVertexStrokeFunction().apply(v);
        } else {
            fillPaint = renderContext.getVertexFillPaintFunction().apply(v);
            drawPaint = renderContext.getVertexDrawPaintFunction().apply(v);
            drawStroke = renderContext.getVertexStrokeFunction().apply(v);
        }
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
            g.setPaint(oldPaint);
        }
        if (drawPaint != null) {
            g.setPaint(drawPaint);
            Stroke oldStroke = g.getStroke();
            if (drawStroke != null) {
                g.setStroke(drawStroke);
            }
            g.draw(shape);
            g.setPaint(oldPaint);
            g.setStroke(oldStroke);
        }
    }

    protected abstract void paintIconForVertex(RenderContext<V, E> var1, LayoutModel<V> var2, V var3);
}

