/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control.modal;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import org.jungrapht.visualization.control.modal.Modal;

public class ModeComboBox
extends JComboBox<Modal.Mode>
implements Modal {
    protected Modal.Mode[] modes;
    protected Set<Modal> modals;
    protected Modal.Mode mode;

    public static Builder builder() {
        return new Builder();
    }

    ModeComboBox(Builder builder) {
        this(builder.mode, builder.modals, builder.modes);
    }

    private ModeComboBox(Modal.Mode mode, Set<Modal> modals, Modal.Mode[] modes) {
        super(modes);
        this.mode = mode;
        this.modes = modes;
        this.modals = modals;
        if (this.mode == null) {
            this.mode = modes[0];
        }
        this.setSelectedItem((Object)mode);
    }

    public boolean addModal(Modal modal) {
        return this.modals.add(modal);
    }

    public boolean removeModal(Modal modal) {
        return this.modals.remove(modal);
    }

    public void addModals(Modal ... modals) {
        Stream.of(modals).forEach(this.modals::add);
    }

    public void removeModal(Modal ... modals) {
        Stream.of(modals).forEach(this.modals::remove);
    }

    public ModeComboBox buildUI() {
        this.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Modal.Mode mode = (Modal.Mode)((Object)((Object)e.getItem()));
                this.setMode(mode);
                this.modals.forEach(modal -> modal.setMode(mode));
            }
        });
        this.modals.forEach(modal -> modal.setMode(this.mode));
        this.setMode(this.mode);
        return this;
    }

    @Override
    public void setMode(Modal.Mode mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.setSelectedItem((Object)mode);
        }
    }

    @Override
    public Modal.Mode getMode() {
        return this.mode;
    }

    public static class Builder {
        protected Modal.Mode[] modes;
        protected Set<Modal> modals = new LinkedHashSet<Modal>();
        protected Modal.Mode mode = Modal.Mode.TRANSFORMING;

        public Builder modes(Modal.Mode ... modes) {
            this.modes = modes;
            return this;
        }

        public Builder modals(Modal ... modals) {
            this.modals = Stream.of(modals).collect(Collectors.toCollection(LinkedHashSet::new));
            return this;
        }

        public Builder mode(Modal.Mode mode) {
            this.mode = mode;
            return this;
        }

        public ModeComboBox build() {
            return new ModeComboBox(this);
        }
    }
}

