/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.lang.Language;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class eBPF_ElfExtension
extends ElfExtension {
    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 247 && elf.is64Bit();
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "eBPF".equals(language.getProcessor().toString()) && language.getLanguageDescription().getSize() == 64;
    }

    public String getDataTypeSuffix() {
        return "eBPF";
    }

    public void processGotPlt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        if (!this.canHandle(elfLoadHelper)) {
            return;
        }
        super.processGotPlt(elfLoadHelper, monitor);
    }
}

