/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.mm;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;
import sarif.managers.MemoryMapBytesFile;

public class ExtMemoryMap
implements IsfObject {
    String name;
    String kind;
    String comment;
    boolean isVolatile;
    boolean isArtificial;
    String type;
    String location;

    public ExtMemoryMap(AddressRange range, MemoryBlock block, MemoryMapBytesFile bf, boolean write) throws IOException {
        Object permissions = "";
        if (block.isRead()) {
            permissions = (String)permissions + "r";
        }
        if (block.isWrite()) {
            permissions = (String)permissions + "w";
        }
        if (block.isExecute()) {
            permissions = (String)permissions + "x";
        }
        this.name = block.getName();
        this.kind = permissions;
        if (block.getComment() != null) {
            this.comment = block.getComment();
        }
        if (block.isVolatile()) {
            this.isVolatile = true;
        }
        if (block.isArtificial()) {
            this.isArtificial = true;
        }
        this.type = block.getType().name();
        if (block.getType() == MemoryBlockType.BIT_MAPPED || block.getType() == MemoryBlockType.BYTE_MAPPED) {
            MemoryBlockSourceInfo info = (MemoryBlockSourceInfo)block.getSourceInfos().get(0);
            this.location = ((AddressRange)info.getMappedRange().get()).getMinAddress().toString();
        } else if (block.isInitialized() && write) {
            this.location = bf.getFileName() + ":" + bf.getOffset();
            bf.writeBytes(range);
        }
    }
}

