/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.data;

import com.google.gson.JsonObject;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ISF.IsfBuiltIn;
import ghidra.program.model.data.ISF.IsfDataTypeWriter;
import ghidra.program.model.data.ISF.IsfEnum;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.ISF.IsfTypedObject;
import ghidra.program.model.data.ISF.IsfTypedefBase;
import ghidra.program.model.data.ISF.IsfTypedefPointer;
import ghidra.program.model.data.ISF.IsfUtilities;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.data.ExtIsfComposite;
import sarif.export.data.ExtIsfDynamicComponent;
import sarif.export.data.ExtIsfFunction;
import sarif.export.data.ExtIsfTypedObject;
import sarif.export.data.ExtIsfTypedefBase;
import sarif.export.data.ExtIsfTypedefPointer;
import sarif.export.data.ExtIsfTypedefUser;

public class ExtIsfDataTypeWriter
extends IsfDataTypeWriter {
    public ExtIsfDataTypeWriter(DataTypeManager dtm, List<DataType> target, Writer baseWriter) throws IOException {
        super(dtm, target, baseWriter);
        this.STRICT = false;
    }

    public JsonObject getRootObject(TaskMonitor monitor) throws CancelledException, IOException {
        this.genRoot(monitor);
        return this.root;
    }

    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        super.genRoot(monitor);
        this.data.add("functions", this.functions);
    }

    protected IsfObject getIsfObject(DataType dt, TaskMonitor monitor) throws IOException, CancelledException {
        if (dt == null) {
            throw new IOException("Null datatype passed to getIsfObject");
        }
        if (dt instanceof FactoryDataType) {
            Msg.error((Object)((Object)this), (Object)("Factory root types may not be written - type: " + String.valueOf(dt)));
        }
        if (dt instanceof BitFieldDataType) {
            Msg.error((Object)((Object)this), (Object)("BitField data types may not be written - type: " + String.valueOf(dt)));
        }
        if (dt instanceof Pointer || dt instanceof Array) {
            IsfObject type = this.getObjectDataType(IsfUtilities.getBaseDataType((DataType)dt));
            ExtIsfTypedObject obj = new ExtIsfTypedObject(dt, type);
            return obj;
        }
        IsfObject res = this.resolve(dt = dt.clone(this.dtm));
        if (res != null) {
            return res;
        }
        if (dt instanceof Dynamic) {
            Dynamic dynamic = (Dynamic)dt;
            DataType rep = dynamic.getReplacementBaseType();
            return rep == null ? null : this.getIsfObject(rep, monitor);
        }
        if (dt instanceof BuiltInDataType) {
            BuiltInDataType builtin = (BuiltInDataType)dt;
            return new IsfBuiltIn(builtin);
        }
        if (dt instanceof TypeDef) {
            TypeDef typedef = (TypeDef)dt;
            return this.getObjectTypeDef(typedef, monitor);
        }
        if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            return new ExtIsfComposite(composite, this, monitor);
        }
        if (dt instanceof Enum) {
            Enum enumm = (Enum)dt;
            return new IsfEnum(enumm);
        }
        if (dt instanceof FunctionDefinition) {
            FunctionDefinition funcDef = (FunctionDefinition)dt;
            return new ExtIsfFunction(funcDef);
        }
        Msg.warn((Object)((Object)this), (Object)("Unable to write datatype. Type unrecognized: " + String.valueOf(dt.getClass())));
        return null;
    }

    public IsfTypedefBase newTypedefBase(TypeDef typeDef) {
        return new ExtIsfTypedefBase(typeDef);
    }

    public IsfTypedefPointer newTypedefPointer(TypeDef typeDef) {
        return new ExtIsfTypedefPointer(typeDef);
    }

    public IsfObject newTypedefUser(TypeDef typeDef, IsfObject object) {
        return new ExtIsfTypedefUser(typeDef, object);
    }

    public IsfTypedObject newTypedObject(DataType dt, IsfObject type) {
        return new ExtIsfTypedObject(dt, type);
    }

    public IsfObject newIsfDynamicComponent(Dynamic dynamic, IsfObject type, int elementCnt) {
        return new ExtIsfDynamicComponent(dynamic, type, elementCnt);
    }
}

