/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import java.util.ArrayList;
import java.util.List;

public class SarifProgramOptions {
    public static final long OPT_MEMORY_BLOCKS = 1L;
    public static final long OPT_MEMORY_CONTENTS = 2L;
    public static final long OPT_CODE = 4L;
    public static final long OPT_DATA = 8L;
    public static final long OPT_SYMBOLS = 16L;
    public static final long OPT_EQUATES = 32L;
    public static final long OPT_COMMENTS = 64L;
    public static final long OPT_PROPERTIES = 128L;
    public static final long OPT_TREES = 256L;
    public static final long OPT_EMPTY_TREE_NODES = 512L;
    public static final long OPT_REFERENCES = 1024L;
    public static final long OPT_FUNCTIONS = 2048L;
    public static final long OVERWRITE_SYMBOLS = 0x20000000L;
    public static final long OVERWRITE_REFS = 0x40000000L;
    public static final long ADD_2_PROG = 0x80000000L;
    private boolean addToProgram = false;
    private boolean memoryBlocks = true;
    private boolean memoryContents = true;
    private boolean overwriteMemoryConflicts = false;
    private boolean instructions = true;
    private boolean overwriteDataConflicts = true;
    private boolean data = true;
    private boolean symbols = true;
    private boolean overwriteSymbolConflicts = true;
    private boolean equates = true;
    private boolean comments = true;
    private boolean properties = true;
    private boolean overwritePropertyConflicts = true;
    private boolean bookmarks = true;
    private boolean overwriteBookmarkConflicts = true;
    private boolean trees = true;
    private boolean references = true;
    private boolean overwriteReferenceConflicts = true;
    private boolean functions = true;
    private boolean registers = true;
    private boolean relocationTable = true;
    private boolean entryPoints = true;
    private boolean externalLibraries = true;
    private boolean applyProcDefinedLabels = false;
    private boolean anchorProcDefinedLabels = true;

    public List<Option> getOptions(boolean isAddToProgram) {
        this.addToProgram = isAddToProgram;
        ArrayList<Option> optionList = new ArrayList<Option>();
        optionList.add(new Option("Memory Blocks", (Object)this.isMemoryBlocks()));
        optionList.add(new Option("Memory Contents", (Object)this.isMemoryContents()));
        if (isAddToProgram) {
            optionList.add(new Option("Overwrite Memory Conflicts", (Object)this.isOverwriteMemoryConflicts()));
        }
        optionList.add(new Option("Instructions", (Object)this.isInstructions()));
        optionList.add(new Option("Data", (Object)this.isData()));
        if (isAddToProgram) {
            optionList.add(new Option("Overwrite Data Conflicts", (Object)this.isOverwriteDataConflicts()));
        }
        optionList.add(new Option("Symbols", (Object)this.isSymbols()));
        if (isAddToProgram) {
            optionList.add(new Option("Overwrite Symbol Conflicts", (Object)this.isOverwriteSymbolConflicts()));
        }
        optionList.add(new Option("Equates", (Object)this.isEquates()));
        optionList.add(new Option("Comments", (Object)this.isComments()));
        optionList.add(new Option("Properties", (Object)this.isProperties()));
        if (isAddToProgram) {
            optionList.add(new Option("Overwrite Property Conflicts", (Object)this.isOverwritePropertyConflicts()));
        }
        optionList.add(new Option("Bookmarks", (Object)this.isBookmarks()));
        if (isAddToProgram) {
            optionList.add(new Option("Overwrite Bookmark Conflicts", (Object)this.isOverwriteBookmarkConflicts()));
        }
        optionList.add(new Option("Trees", (Object)this.isTrees()));
        optionList.add(new Option("References", (Object)this.isReferences()));
        if (isAddToProgram) {
            optionList.add(new Option("Overwrite Reference Conflicts", (Object)this.isOverwriteReferenceConflicts()));
        }
        optionList.add(new Option("Functions", (Object)this.isFunctions()));
        optionList.add(new Option("Registers", (Object)this.isRegisters()));
        optionList.add(new Option("Relocation Table", (Object)this.isRelocationTable()));
        optionList.add(new Option("Entry Points", (Object)this.isEntryPoints()));
        optionList.add(new Option("External Libraries", (Object)this.isExternalLibraries()));
        optionList.add(new Option("Apply Processor Defined Labels", (Object)this.applyProcDefinedLabels()));
        optionList.add(new Option("Anchor Processor Defined Labels", (Object)this.anchorProcDefinedLabels()));
        return optionList;
    }

    public void setOptions(List<Option> options) throws OptionException {
        for (Option option : options) {
            String optName = option.getName();
            Object optValue = option.getValue();
            if (!(optValue instanceof Boolean)) {
                throw new OptionException("Invalid type for option: " + optName);
            }
            boolean val = (Boolean)optValue;
            if (optName.equals("Memory Blocks")) {
                this.setMemoryBlocks(val);
                continue;
            }
            if (optName.equals("Memory Contents")) {
                this.setMemoryContents(val);
                continue;
            }
            if (optName.equals("Overwrite Memory Conflicts")) {
                this.setOverwriteMemoryConflicts(val);
                continue;
            }
            if (optName.equals("Instructions")) {
                this.setInstructions(val);
                continue;
            }
            if (optName.equals("Data")) {
                this.setData(val);
                continue;
            }
            if (optName.equals("Overwrite Data Conflicts")) {
                this.setOverwriteDataConflicts(val);
                continue;
            }
            if (optName.equals("Symbols")) {
                this.setSymbols(val);
                continue;
            }
            if (optName.equals("Overwrite Symbol Conflicts")) {
                this.setOverwriteSymbolConflicts(val);
                continue;
            }
            if (optName.equals("Equates")) {
                this.setEquates(val);
                continue;
            }
            if (optName.equals("Comments")) {
                this.setComments(val);
                continue;
            }
            if (optName.equals("Properties")) {
                this.setProperties(val);
                continue;
            }
            if (optName.equals("Overwrite Property Conflicts")) {
                this.setOverwritePropertyConflicts(val);
                continue;
            }
            if (optName.equals("Bookmarks")) {
                this.setBookmarks(val);
                continue;
            }
            if (optName.equals("Overwrite Bookmark Conflicts")) {
                this.setOverwriteBookmarkConflicts(val);
                continue;
            }
            if (optName.equals("Trees")) {
                this.setTrees(val);
                continue;
            }
            if (optName.equals("References")) {
                this.setReferences(val);
                continue;
            }
            if (optName.equals("Overwrite Reference Conflicts")) {
                this.setOverwriteReferenceConflicts(val);
                continue;
            }
            if (optName.equals("Functions")) {
                this.setFunctions(val);
                continue;
            }
            if (optName.equals("Registers")) {
                this.setRegisters(val);
                continue;
            }
            if (optName.equals("Relocation Table")) {
                this.setRelocationTable(val);
                continue;
            }
            if (optName.equals("Entry Points")) {
                this.setEntryPoints(val);
                continue;
            }
            if (optName.equals("External Libraries")) {
                this.setExternalLibraries(val);
                continue;
            }
            if (optName.equals("Apply Processor Defined Labels")) {
                this.setExternalLibraries(val);
                continue;
            }
            if (optName.equals("Anchor Processor Defined Labels")) {
                this.setExternalLibraries(val);
                continue;
            }
            throw new OptionException("Unknown option: " + optName);
        }
    }

    public boolean isAddToProgram() {
        return this.addToProgram;
    }

    public boolean isInstructions() {
        return this.instructions;
    }

    public boolean isComments() {
        return this.comments;
    }

    public boolean isData() {
        return this.data;
    }

    public boolean isEquates() {
        return this.equates;
    }

    public boolean isFunctions() {
        return this.functions;
    }

    public boolean isMemoryBlocks() {
        return this.memoryBlocks;
    }

    public boolean isMemoryContents() {
        return this.memoryContents;
    }

    public boolean isProperties() {
        return this.properties;
    }

    public boolean isReferences() {
        return this.references;
    }

    public boolean isSymbols() {
        return this.symbols;
    }

    public boolean isTrees() {
        return this.trees;
    }

    public void setInstructions(boolean b) {
        this.instructions = b;
    }

    public void setComments(boolean b) {
        this.comments = b;
    }

    public void setData(boolean b) {
        this.data = b;
    }

    public void setEquates(boolean b) {
        this.equates = b;
    }

    public void setFunctions(boolean b) {
        this.functions = b;
    }

    public void setMemoryBlocks(boolean b) {
        this.memoryBlocks = b;
    }

    public void setMemoryContents(boolean b) {
        this.memoryContents = b;
    }

    public void setProperties(boolean b) {
        this.properties = b;
    }

    public void setReferences(boolean b) {
        this.references = b;
    }

    public void setSymbols(boolean b) {
        this.symbols = b;
    }

    public void setTrees(boolean b) {
        this.trees = b;
    }

    public boolean isBookmarks() {
        return this.bookmarks;
    }

    public boolean isRegisters() {
        return this.registers;
    }

    public boolean isRelocationTable() {
        return this.relocationTable;
    }

    public void setBookmarks(boolean b) {
        this.bookmarks = b;
    }

    public void setRegisters(boolean b) {
        this.registers = b;
    }

    public void setRelocationTable(boolean b) {
        this.relocationTable = b;
    }

    public boolean isEntryPoints() {
        return this.entryPoints;
    }

    public boolean isExternalLibraries() {
        return this.externalLibraries;
    }

    public void setEntryPoints(boolean b) {
        this.entryPoints = b;
    }

    public void setExternalLibraries(boolean b) {
        this.externalLibraries = b;
    }

    public boolean isOverwritePropertyConflicts() {
        return this.overwritePropertyConflicts;
    }

    public boolean isOverwriteBookmarkConflicts() {
        return this.overwriteBookmarkConflicts;
    }

    public boolean isOverwriteSymbolConflicts() {
        return this.overwriteSymbolConflicts;
    }

    public boolean isOverwriteReferenceConflicts() {
        return this.overwriteReferenceConflicts;
    }

    public boolean isOverwriteMemoryConflicts() {
        return this.overwriteMemoryConflicts;
    }

    public boolean isOverwriteDataConflicts() {
        return this.overwriteDataConflicts;
    }

    public void setOverwriteBookmarkConflicts(boolean b) {
        this.overwriteBookmarkConflicts = b;
    }

    public void setOverwriteMemoryConflicts(boolean b) {
        this.overwriteMemoryConflicts = b;
    }

    public void setOverwriteDataConflicts(boolean b) {
        this.overwriteDataConflicts = b;
    }

    public void setOverwritePropertyConflicts(boolean b) {
        this.overwritePropertyConflicts = b;
    }

    public void setOverwriteReferenceConflicts(boolean b) {
        this.overwriteReferenceConflicts = b;
    }

    public void setOverwriteSymbolConflicts(boolean b) {
        this.overwriteSymbolConflicts = b;
    }

    public boolean applyProcDefinedLabels() {
        return this.applyProcDefinedLabels;
    }

    public void setApplyProcDefinedLabels(boolean b) {
        this.applyProcDefinedLabels = b;
    }

    public void setAnchorProcDefinedLabels(boolean b) {
        this.anchorProcDefinedLabels = b;
    }

    public boolean anchorProcDefinedLabels() {
        return this.anchorProcDefinedLabels;
    }

    public void setAddToProgram(boolean addToProgram) {
        this.addToProgram = addToProgram;
    }
}

