/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.columnfilter;

import docking.DockingWindowManager;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.menu.NonToolbarMultiStateAction;
import docking.widgets.EventTrigger;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnFilterSaveManager;
import docking.widgets.table.constraint.dialog.ColumnFilterDialog;
import generic.theme.GIcon;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import resources.Icons;
import utility.function.Callback;

public class ColumnFilterManager<ROW_OBJECT> {
    public static final String FILTER_EXTENSION = ".FilterExtension";
    public static final String FILTER_TEXTFIELD_NAME = "filter.panel.textfield";
    private static final Icon FILTER_ON_ICON = new GIcon("icon.widget.filterpanel.filter.on");
    private static final Icon FILTER_OFF_ICON = new GIcon("icon.widget.filterpanel.filter.off");
    private static final Icon APPLY_FILTER_ICON = Icons.OPEN_FOLDER_ICON;
    private static final Icon CLEAR_FILTER_ICON = Icons.DELETE_ICON;
    private MultiStateDockingAction<ColumnBasedTableFilter<ROW_OBJECT>> columnFilterAction;
    private JButton configureButton;
    private ColumnFilterDialog<ROW_OBJECT> columnFilterDialog;
    private ColumnBasedTableFilter<ROW_OBJECT> lastUsedFilter;
    private ColumnBasedTableFilter<ROW_OBJECT> currentFilter;
    private List<ColumnBasedTableFilter<ROW_OBJECT>> savedFilters = new ArrayList<ColumnBasedTableFilter<ROW_OBJECT>>();
    private JTable table;
    private RowObjectFilterModel<ROW_OBJECT> rowObjectFilterModel;
    private String preferenceKey;
    private Callback filterChangedCallback;

    public ColumnFilterManager(JTable table, RowObjectFilterModel<ROW_OBJECT> rowObjectFilterModel, String preferenceKey, Callback filterChangedCallback) {
        this.table = Objects.requireNonNull(table);
        this.rowObjectFilterModel = Objects.requireNonNull(rowObjectFilterModel);
        this.preferenceKey = Objects.requireNonNull(preferenceKey);
        this.filterChangedCallback = Objects.requireNonNull(filterChangedCallback);
        this.configureButton = this.buildColumnFilterStateButton();
        DockingWindowManager.registerComponentLoadedListener(table, (windowManager, provider) -> this.initializeSavedFilters());
    }

    private void initializeSavedFilters() {
        TableModel model = this.table.getModel();
        if (!(model instanceof GDynamicColumnTableModel)) {
            return;
        }
        GDynamicColumnTableModel dynamicModel = (GDynamicColumnTableModel)model;
        ColumnFilterSaveManager saveManager = new ColumnFilterSaveManager(this.preferenceKey, this.table, dynamicModel, dynamicModel.getDataSource());
        this.savedFilters = saveManager.getSavedFilters();
        Collections.reverse(this.savedFilters);
        this.updateColumnFilterButton();
    }

    public ColumnBasedTableFilter<ROW_OBJECT> getCurrentFilter() {
        return this.currentFilter;
    }

    public JButton getConfigureButton() {
        return this.configureButton;
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setFilter(ColumnBasedTableFilter<ROW_OBJECT> newFilter) {
        if (Objects.equals(newFilter, this.currentFilter)) {
            return;
        }
        if (this.currentFilter != null && !this.currentFilter.isSaved()) {
            this.lastUsedFilter = this.currentFilter;
        }
        this.currentFilter = newFilter;
        this.updateColumnFilterButton();
        if (this.columnFilterDialog != null) {
            this.columnFilterDialog.filterChanged(newFilter);
        }
        this.filterChangedCallback.call();
    }

    public void updateSavedFilters(ColumnBasedTableFilter<ROW_OBJECT> filter, boolean add) {
        if (add) {
            ArrayList<ColumnBasedTableFilter<ROW_OBJECT>> list = new ArrayList<ColumnBasedTableFilter<ROW_OBJECT>>();
            list.add(filter);
            list.addAll(this.savedFilters);
            this.savedFilters = list;
            if (filter.isEquivalent(this.currentFilter)) {
                this.setFilter(filter);
            }
        } else {
            this.savedFilters.remove(filter);
        }
        this.updateColumnFilterButton();
        this.filterChangedCallback.call();
    }

    public void dispose() {
        if (this.columnFilterDialog != null) {
            this.columnFilterDialog.dispose();
            this.columnFilterDialog = null;
        }
        this.filterChangedCallback = Callback.dummy();
    }

    private JButton buildColumnFilterStateButton() {
        this.columnFilterAction = new NonToolbarMultiStateAction<ColumnBasedTableFilter<ROW_OBJECT>>("Column Filter", "GTableFilterPanel"){

            @Override
            public void actionStateChanged(ActionState<ColumnBasedTableFilter<ROW_OBJECT>> newActionState, EventTrigger trigger) {
                if (trigger != EventTrigger.GUI_ACTION) {
                    return;
                }
                ColumnFilterActionState state = (ColumnFilterActionState)newActionState;
                state.performAction();
            }

            @Override
            protected void actionPerformed() {
                ColumnFilterManager.this.showFilterDialog(ColumnFilterManager.this.rowObjectFilterModel);
            }
        };
        HelpLocation helpLocation = new HelpLocation("Trees", "Column_Filters");
        this.columnFilterAction.setHelpLocation(helpLocation);
        this.updateColumnFilterButton();
        JButton button = this.columnFilterAction.createButton();
        DockingWindowManager.getHelpService().registerHelp((Object)button, helpLocation);
        return button;
    }

    private void updateColumnFilterButton() {
        List list = this.getActionStates();
        this.columnFilterAction.setActionStates(list);
    }

    private List<ActionState<ColumnBasedTableFilter<ROW_OBJECT>>> getActionStates() {
        ArrayList<ActionState<ColumnBasedTableFilter<ROW_OBJECT>>> list = new ArrayList<ActionState<ColumnBasedTableFilter<ROW_OBJECT>>>();
        if (this.currentFilter == null) {
            list.add(new CreateFilterActionState());
        } else {
            list.add(new EditFilterActionState(this.currentFilter));
            list.add(new ClearFilterActionState());
        }
        if (this.lastUsedFilter != null) {
            list.add(new ApplyLastUsedActionState(this.lastUsedFilter));
        }
        for (ColumnBasedTableFilter<ROW_OBJECT> filter : this.savedFilters) {
            list.add(new ApplyFilterActionState(filter));
        }
        return list;
    }

    private void showFilterDialog(RowObjectFilterModel<ROW_OBJECT> tableModel) {
        if (this.columnFilterDialog == null) {
            if (ColumnFilterDialog.hasFilterableColumns(this.table, tableModel)) {
                this.columnFilterDialog = new ColumnFilterDialog<ROW_OBJECT>(this, this.table, this.rowObjectFilterModel);
            } else {
                Msg.showError((Object)this, null, (String)"Column Filter Error", (Object)"This table contains no filterable columns!");
                return;
            }
        }
        DockingWindowManager.showDialog(this.table, this.columnFilterDialog);
    }

    String getFilterName(ColumnBasedTableFilter<ROW_OBJECT> filter) {
        String filterName = filter.getName();
        return filterName == null ? "Unsaved" : filterName;
    }

    private class CreateFilterActionState
    extends ColumnFilterActionState {
        public CreateFilterActionState() {
            super(ColumnFilterManager.this, "Create Column Filter", FILTER_OFF_ICON, null);
        }

        @Override
        void performAction() {
            ColumnFilterManager.this.showFilterDialog(ColumnFilterManager.this.rowObjectFilterModel);
        }
    }

    private class EditFilterActionState
    extends ColumnFilterActionState {
        public EditFilterActionState(ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super(ColumnFilterManager.this, "Edit: " + ColumnFilterManager.this.getFilterName(filter), FILTER_ON_ICON, filter);
        }

        @Override
        void performAction() {
            ColumnFilterManager.this.showFilterDialog(ColumnFilterManager.this.rowObjectFilterModel);
        }
    }

    private class ClearFilterActionState
    extends ColumnFilterActionState {
        public ClearFilterActionState() {
            super(ColumnFilterManager.this, "Clear Filter", CLEAR_FILTER_ICON, null);
        }

        @Override
        void performAction() {
            ColumnFilterManager.this.setFilter(null);
        }
    }

    private class ApplyLastUsedActionState
    extends ColumnFilterActionState {
        public ApplyLastUsedActionState(ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super(ColumnFilterManager.this, "Apply Last Unsaved", FILTER_ON_ICON, filter);
        }

        @Override
        void performAction() {
            ColumnFilterManager.this.setFilter((ColumnBasedTableFilter)this.getUserData());
        }
    }

    private class ApplyFilterActionState
    extends ColumnFilterActionState {
        public ApplyFilterActionState(ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super(ColumnFilterManager.this, "Apply: " + ColumnFilterManager.this.getFilterName(filter), APPLY_FILTER_ICON, filter);
        }

        @Override
        void performAction() {
            ColumnFilterManager.this.setFilter((ColumnBasedTableFilter)this.getUserData());
        }
    }

    private abstract class ColumnFilterActionState
    extends ActionState<ColumnBasedTableFilter<ROW_OBJECT>> {
        ColumnFilterActionState(ColumnFilterManager columnFilterManager, String name, Icon icon, ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super(name, icon, filter);
        }

        abstract void performAction();
    }
}

