/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tabbedpane;

import docking.CloseIcon;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDLabel;
import generic.theme.GColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DockingTabRenderer
extends JPanel {
    private static final int MAX_TITLE_LENGTH = 25;
    private Icon CLOSE_ICON = new CloseIcon(true, (Color)new GColor("color.fg.button"));
    private JLabel titleLabel;
    private JLabel iconLabel;
    private JButton closeButton;
    private HierarchyListener hierarchyListener;
    private TabContainerForwardingMouseListener forwardingListener;
    private MouseListener renameListener;

    public DockingTabRenderer(JTabbedPane tabbedPane, String fullTitle, String tabTitle, ActionListener closeListener) {
        ForwardingMouseListener eventForwardingListener = new ForwardingMouseListener(tabbedPane);
        this.titleLabel = new GDLabel();
        this.iconLabel = new GDLabel();
        this.closeButton = new EmptyBorderButton();
        this.setTitle(tabTitle, fullTitle);
        this.closeButton.setToolTipText("Close " + tabTitle);
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(closeListener);
        this.closeButton.setIcon(this.CLOSE_ICON);
        this.closeButton.setRolloverIcon(this.CLOSE_ICON);
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 0));
        container.add(this.iconLabel);
        container.add(Box.createHorizontalStrut(5));
        container.add(this.titleLabel);
        container.add(Box.createHorizontalStrut(5));
        container.add(Box.createHorizontalGlue());
        container.add(this.closeButton);
        this.setLayout(new BorderLayout());
        this.add((Component)container, "Center");
        this.setOpaque(false);
        container.setOpaque(false);
        this.closeButton.setOpaque(false);
        this.iconLabel.addMouseListener(eventForwardingListener);
        this.iconLabel.addMouseMotionListener(eventForwardingListener);
        this.titleLabel.addMouseListener(eventForwardingListener);
        this.titleLabel.addMouseMotionListener(eventForwardingListener);
        this.installMouseForwardingListenerWorkaround(tabbedPane);
    }

    private void installMouseForwardingListenerWorkaround(JTabbedPane tabbedPane) {
        this.forwardingListener = new TabContainerForwardingMouseListener(this, tabbedPane);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if (2L == (changeFlags & 2L)) {
                    Container myParent = DockingTabRenderer.this.getParent();
                    boolean isDisplayable = DockingTabRenderer.this.isDisplayable();
                    if (isDisplayable) {
                        myParent.removeMouseListener(DockingTabRenderer.this.forwardingListener);
                        myParent.removeMouseMotionListener(DockingTabRenderer.this.forwardingListener);
                        myParent.addMouseListener(DockingTabRenderer.this.forwardingListener);
                        myParent.addMouseMotionListener(DockingTabRenderer.this.forwardingListener);
                        DockingTabRenderer.this.hierarchyListener = this;
                    } else if (DockingTabRenderer.this.hierarchyListener != null) {
                        myParent.removeMouseListener(DockingTabRenderer.this.forwardingListener);
                        myParent.removeMouseMotionListener(DockingTabRenderer.this.forwardingListener);
                        DockingTabRenderer.this.removeHierarchyListener(DockingTabRenderer.this.hierarchyListener);
                    }
                }
            }
        });
    }

    private String getShortenedTitle(String title) {
        if (((String)title).length() > 25) {
            title = ((String)title).substring(0, 22) + "...";
        }
        return title;
    }

    public void installRenameAction(MouseListener listener) {
        this.renameListener = listener;
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    public void setTitle(String tabTitle, String fullTitle) {
        this.titleLabel.setText(this.getShortenedTitle(tabTitle));
        String trimmedTabText = tabTitle.trim();
        String trimmedTitleText = fullTitle.trim();
        if (trimmedTabText.equals(trimmedTitleText)) {
            this.titleLabel.setToolTipText(tabTitle);
        } else if (trimmedTitleText.contains(trimmedTabText)) {
            this.titleLabel.setToolTipText(fullTitle);
        } else {
            this.titleLabel.setToolTipText("<html><b>" + tabTitle + "</b> - [" + fullTitle + "]");
        }
    }

    public String getTabText() {
        return this.titleLabel.getText();
    }

    private class ForwardingMouseListener
    implements MouseListener,
    MouseMotionListener {
        private final Component handler;

        ForwardingMouseListener(Component handler) {
            this.handler = handler;
        }

        private void forwardEvent(MouseEvent e) {
            MouseEvent newEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.handler);
            this.handler.dispatchEvent(newEvent);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.consumePopup(e)) {
                return;
            }
            this.forwardEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.consumePopup(e)) {
                return;
            }
            this.forwardEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.consumePopup(e)) {
                return;
            }
            this.forwardEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.forwardEvent(e);
        }

        private boolean consumePopup(MouseEvent e) {
            if (DockingTabRenderer.this.renameListener == null) {
                return false;
            }
            if (!e.isPopupTrigger()) {
                return false;
            }
            DockingTabRenderer.this.renameListener.mouseClicked(e);
            return true;
        }
    }

    private class TabContainerForwardingMouseListener
    extends MouseAdapter {
        private final JTabbedPane tabbedPane;

        TabContainerForwardingMouseListener(DockingTabRenderer dockingTabRenderer, JTabbedPane tabbedPane) {
            this.tabbedPane = tabbedPane;
        }

        private void maybeForwardMousePressedEvent(MouseEvent e) {
            MouseEvent tabbedPaneRelativeMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.tabbedPane);
            this.tabbedPane.dispatchEvent(tabbedPaneRelativeMouseEvent);
        }

        private void forwardMouseMotionEvent(MouseEvent e) {
            e.consume();
            MouseEvent newEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.tabbedPane);
            this.tabbedPane.dispatchEvent(newEvent);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.maybeForwardMousePressedEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.maybeForwardMousePressedEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.maybeForwardMousePressedEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.forwardMouseMotionEvent(e);
        }
    }
}

