/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.HintTextField;
import ghidra.util.NumericUtilities;
import ghidra.util.datastruct.SortedRangeList;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberRangeInputDialog
extends DialogComponentProvider {
    private static final String RANGE_DELIMITER = ":";
    private static final String DEFAULT_VALUE = "";
    private static final String HINT_TEXT = "e.g. 2,5 or 1,4:8";
    private static final int MAX_SIZE = 256;
    private boolean wasCancelled;
    private String inputLabel;
    private String initialValue = "";
    private SortedRangeList rangeList = new SortedRangeList();
    private HintTextField textField;
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 10) {
                NumberRangeInputDialog.this.okCallback();
            }
        }
    };

    public NumberRangeInputDialog(String title, String label) {
        super(title, true, true, true, false);
        this.inputLabel = label;
        this.setTransient(true);
        this.addOKButton();
        this.addCancelButton();
        this.buildMainPanel();
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NumberRangeInputDialog.this.clearStatusText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NumberRangeInputDialog.this.clearStatusText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NumberRangeInputDialog.this.clearStatusText();
            }
        };
        this.textField.getDocument().addDocumentListener(docListener);
        this.setFocusComponent(this.textField);
    }

    private void buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5, 120));
        this.textField = new MyHintTextField(HINT_TEXT);
        this.textField.setText(this.initialValue);
        this.textField.addKeyListener(this.keyListener);
        this.textField.setName("number.range.input.dialog.text.field");
        this.textField.getAccessibleContext().setAccessibleName("Number Range Input");
        panel.add(new GLabel(this.inputLabel, 4));
        panel.add(this.textField);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.getAccessibleContext().setAccessibleName("Number Range Input");
        this.addWorkPanel(panel);
    }

    public boolean show() {
        DockingWindowManager.showDialog(this);
        return !this.wasCancelled;
    }

    @Override
    protected void okCallback() {
        this.wasCancelled = false;
        if (!this.parseRanges()) {
            return;
        }
        this.close();
    }

    JTextField getTextField() {
        return this.textField;
    }

    private boolean parseRanges() {
        String[] parts;
        String value = this.textField.getText();
        for (String rangeText : parts = value.split(",")) {
            if (this.addRange(rangeText)) continue;
            return false;
        }
        return true;
    }

    private boolean addRange(String rangeText) {
        String trimmed = rangeText.trim();
        if (!trimmed.contains(RANGE_DELIMITER)) {
            try {
                int intValue = NumericUtilities.parseInt((String)trimmed);
                this.rangeList.addRange(intValue, intValue);
            }
            catch (NumberFormatException e) {
                this.setStatusText("Unable to parse as a number: '" + trimmed + "'");
                return false;
            }
            return true;
        }
        String[] startAndEnd = trimmed.split(RANGE_DELIMITER);
        try {
            int startInt = NumericUtilities.parseInt((String)startAndEnd[0]);
            int endInt = NumericUtilities.parseInt((String)startAndEnd[1]);
            this.rangeList.addRange(startInt, endInt);
        }
        catch (NumberFormatException e) {
            this.setStatusText("Unable to parse as a number: '" + trimmed + "'");
            return false;
        }
        return true;
    }

    @Override
    protected void cancelCallback() {
        this.wasCancelled = true;
        this.rangeList.clear();
        this.close();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public SortedRangeList getValue() {
        return this.rangeList;
    }

    public void setValue(String text) {
        this.textField.setText(text);
    }

    private class MyHintTextField
    extends HintTextField {
        MyHintTextField(String hintText) {
            super(hintText);
            this.setColumns(20);
        }

        @Override
        protected Document createDefaultModel() {
            return new MyDocument(this);
        }

        private class MyDocument
        extends PlainDocument {
            private JTextField documentTf;

            private MyDocument(JTextField textField) {
                this.documentTf = textField;
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                String text = this.documentTf.getText();
                if (text.length() + str.length() > 256) {
                    int nTooMany = text.length() + str.length() - 256;
                    int len = str.length() - nTooMany;
                    str = str.substring(0, len);
                }
                super.insertString(offs, str, a);
            }
        }
    }
}

