/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.protocol.ClusterNote;
import ghidra.features.bsim.query.protocol.QueryCluster;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResponseCluster
extends QueryResponseRecord {
    public List<ClusterNote> notes = new ArrayList<ClusterNote>();
    public QueryCluster query;

    public ResponseCluster(QueryCluster q) {
        super("responsecluster");
        this.query = q;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        this.query.manage.populateExecutableXref();
        fwrite.append('<').append(this.name).append(">\n");
        Iterator<ClusterNote> iter = this.notes.iterator();
        while (iter.hasNext()) {
            iter.next().saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        Map<Integer, ExecutableRecord> exeMap = this.query.manage.generateExecutableXrefMap();
        parser.start(new String[]{this.name});
        while (parser.peek().isStart()) {
            ClusterNote newnote = new ClusterNote();
            newnote.restoreXml(parser, this.query.manage, exeMap);
            this.notes.add(newnote);
        }
        parser.end();
    }
}

