/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.features.bsim.gui.search.results.BSimApplyResult;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.features.bsim.gui.search.results.BSimStatusRenderer;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AbstractProgramLocationTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class BSimApplyResultsTableModel
extends AddressBasedTableModel<BSimApplyResult> {
    private List<BSimApplyResult> results;
    static final int ADDRESS_INDEX = 0;
    static final int ORIGINAL_NAME_INDEX = 1;
    static final int DESTINATION_NAME_INDEX = 2;
    static final int STATUS_INDEX = 3;

    public BSimApplyResultsTableModel(String title, ServiceProvider serviceProvider, Program program, TaskMonitor monitor, List<BSimApplyResult> results) {
        super("Rename Results", serviceProvider, program, null);
        this.results = results;
    }

    protected TableColumnDescriptor<BSimApplyResult> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new StatusColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AddressColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new OriginalNameColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new DestinationNameColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new MessageColumn(this));
        return descriptor;
    }

    public ProgramLocation getProgramLocation(int row, int column) {
        Address addr = this.getAddress(row);
        return new ProgramLocation(this.program, addr);
    }

    protected void doLoad(Accumulator<BSimApplyResult> accumulator, TaskMonitor monitor) throws CancelledException {
        for (BSimApplyResult result : this.results) {
            accumulator.add((Object)result);
        }
    }

    public Address getAddress(int row) {
        String addressStr = (String)this.getValueAt(row, 0);
        return this.program.getAddressFactory().getAddress(addressStr);
    }

    private static class StatusColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimApplyResult, BSimResultStatus> {
        private BSimStatusRenderer statusRenderer = new BSimStatusRenderer();

        private StatusColumn() {
        }

        public String getColumnName() {
            return "Status";
        }

        public BSimResultStatus getValue(BSimApplyResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getStatus();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public GColumnRenderer<BSimResultStatus> getColumnRenderer() {
            return this.statusRenderer;
        }
    }

    private class AddressColumn
    extends AbstractProgramLocationTableColumn<BSimApplyResult, String> {
        private AddressColumn(BSimApplyResultsTableModel bSimApplyResultsTableModel) {
        }

        public String getColumnName() {
            return "Address";
        }

        public String getValue(BSimApplyResult rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            return rowObject.getAddress().toString();
        }

        public ProgramLocation getProgramLocation(BSimApplyResult rowObject, Settings settings, Program p, ServiceProvider svcProvider) {
            return new ProgramLocation(p, rowObject.getAddress());
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class OriginalNameColumn
    extends AbstractDynamicTableColumn<BSimApplyResult, String, Object> {
        private OriginalNameColumn(BSimApplyResultsTableModel bSimApplyResultsTableModel) {
        }

        public String getColumnName() {
            return "Original Name";
        }

        public String getValue(BSimApplyResult rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getTargetFunctionName();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private class DestinationNameColumn
    extends AbstractDynamicTableColumn<BSimApplyResult, String, Object> {
        private DestinationNameColumn(BSimApplyResultsTableModel bSimApplyResultsTableModel) {
        }

        public String getColumnName() {
            return "Name From Database";
        }

        public String getValue(BSimApplyResult rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getSourceFunctionName();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private class MessageColumn
    extends AbstractDynamicTableColumn<BSimApplyResult, String, Object> {
        private MessageColumn(BSimApplyResultsTableModel bSimApplyResultsTableModel) {
        }

        public String getColumnName() {
            return "Errors/Warnings";
        }

        public String getValue(BSimApplyResult rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getMessage();
        }

        public int getColumnPreferredWidth() {
            return 900;
        }
    }
}

