/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticDatabase;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.sql.SQLException;

public class NotExecutableNameBSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "namenotequal";

    public NotExecutableNameBSimFilterType() {
        super("Executable name does not equal", XML_VALUE, "executable name");
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        effect.setExeTable();
        StringBuilder buf = new StringBuilder();
        buf.append("exetable.name_exec != '").append(atom.value).append('\'');
        effect.addWhere(this, buf.toString());
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"must_not\": { \"term\": { \"name_exec\": \"");
        buffer.append(ElasticDatabase.escape(atom.value));
        buffer.append("\" } } ");
        effect.addStandalone(this, buffer.toString());
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return !value.equals(rec.getNameExec());
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return null;
    }

    @Override
    public boolean orMultipleEntries() {
        return false;
    }
}

