/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.features.bsim.gui.filters.MultiChoiceBSimValueEditor;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.util.DefaultLanguageService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import utility.function.Callback;

public class NotCompilerBSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "compnotequal";

    public NotCompilerBSimFilterType() {
        super("Compiler does not equal", XML_VALUE, "gcc");
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        effect.setExeTable();
        StringBuilder buf = new StringBuilder();
        buf.append("exetable.name_compiler!=").append(resolution.id1);
        effect.addWhere(this, buf.toString());
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        effect.addDocValue("String comp = doc['name_compiler'].value; ");
        String argName = effect.assignArgument();
        effect.addScriptElement(this, "comp != params." + argName);
        effect.addParam(argName, atom.value);
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return !value.equals(rec.getNameCompiler());
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return new IDSQLResolution.Compiler(atom.value);
    }

    @Override
    public boolean orMultipleEntries() {
        return false;
    }

    @Override
    public BSimValueEditor getEditor(List<String> initialValues, Callback listener) {
        List<String> choices = NotCompilerBSimFilterType.getCompilers();
        return new MultiChoiceBSimValueEditor(this, choices, initialValues, "Compiler", listener);
    }

    private static List<String> getCompilers() {
        ArrayList<String> compilers = new ArrayList<String>();
        List languages = DefaultLanguageService.getLanguageService().getLanguageDescriptions(true);
        HashSet<String> compilerIds = new HashSet<String>();
        for (LanguageDescription language : languages) {
            LanguageCompilerSpecQuery query = new LanguageCompilerSpecQuery(language.getProcessor(), language.getEndian(), Integer.valueOf(language.getSize()), language.getVariant(), null);
            for (LanguageCompilerSpecPair specPair : DefaultLanguageService.getLanguageService().getLanguageCompilerSpecPairs(query)) {
                try {
                    String compilerId = specPair.getCompilerSpecDescription().getCompilerSpecID().getIdAsString();
                    if (compilerIds.contains(compilerId)) continue;
                    compilerIds.add(compilerId);
                    compilers.add(compilerId);
                }
                catch (CompilerSpecNotFoundException | LanguageNotFoundException throwable) {}
            }
        }
        return compilers;
    }
}

