/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompileResults;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.util.Objects;

public class DecompilerLocationInfo {
    private Address entryPoint;
    private DecompileResults results;
    private ClangToken token;
    private String tokenName;
    private int lineNumber;
    private int charPos;

    public DecompilerLocationInfo(Address entryPoint, DecompileResults results, ClangToken token, int lineNumber, int charPos) {
        this.entryPoint = entryPoint;
        this.results = results;
        this.token = token;
        this.tokenName = token.getText();
        this.lineNumber = lineNumber;
        this.charPos = charPos;
    }

    public DecompilerLocationInfo() {
    }

    public Address getFunctionEntryPoint() {
        return this.entryPoint;
    }

    public DecompileResults getDecompile() {
        return this.results;
    }

    public ClangToken getToken() {
        return this.token;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharPos() {
        return this.charPos;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.charPos;
        result = 31 * result + (this.entryPoint == null ? 0 : this.entryPoint.hashCode());
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DecompilerLocationInfo other = (DecompilerLocationInfo)obj;
        if (this.charPos != other.charPos) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (!Objects.equals(this.entryPoint, other.entryPoint)) {
            return false;
        }
        return Objects.equals(this.tokenName, other.tokenName);
    }

    public void saveState(SaveState saveState) {
        saveState.putString("_FUNCTION_ENTRY", this.entryPoint.toString());
        saveState.putString("_TOKEN_TEXT", this.tokenName);
        saveState.putInt("_LINE_NUM", this.lineNumber);
        saveState.putInt("_CHAR_POS", this.charPos);
    }

    public void restoreState(Program program1, SaveState obj) {
        String addrStr = obj.getString("_FUNCTION_ENTRY", "0");
        this.entryPoint = program1.parseAddress(addrStr)[0];
        this.tokenName = obj.getString("_TOKEN_TEXT", "");
        this.lineNumber = obj.getInt("_LINE_NUM", 0);
        this.charPos = obj.getInt("_CHAR_POS", 0);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append(", line=");
        buf.append(this.lineNumber);
        buf.append(", character=");
        buf.append(this.charPos);
        buf.append(", token=");
        buf.append(this.tokenName);
        return buf.toString();
    }
}

