/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emulate;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emulate.BreakTable;
import ghidra.pcode.emulate.EmulateDisassemblerContext;
import ghidra.pcode.emulate.EmulateExecutionState;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.EmulateMemoryStateBuffer;
import ghidra.pcode.emulate.InstructionDecodeException;
import ghidra.pcode.emulate.UnimplementedCallOtherException;
import ghidra.pcode.emulate.UnimplementedInstructionException;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryState;
import ghidra.pcode.memstate.UniqueMemoryBank;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.OpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.pcode.pcoderaw.PcodeOpRaw;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.Constructor;
import java.math.BigInteger;

public class Emulate {
    private MemoryState memstate;
    private UniqueMemoryBank uniqueBank;
    private BreakTable breaktable;
    private Address current_address;
    private Address last_execute_address;
    private volatile EmulateExecutionState executionState = EmulateExecutionState.STOPPED;
    private RuntimeException faultCause;
    private int current_op;
    private int last_op;
    private int instruction_length;
    private final SleighLanguage language;
    private final AddressFactory addrFactory;
    private Register pcReg;
    private InstructionBlock lastPseudoInstructionBlock;
    private Disassembler pseudoDisassembler;
    private Instruction pseudoInstruction;
    private PcodeOp[] pcode;
    private RegisterValue nextContextRegisterValue = null;
    private EmulateMemoryStateBuffer memBuffer;
    private EmulateInstructionStateModifier instructionStateModifier;

    public Emulate(SleighLanguage lang, MemoryState s, BreakTable b) {
        this.memstate = s;
        this.language = lang;
        this.addrFactory = lang.getAddressFactory();
        this.pcReg = lang.getProgramCounter();
        this.breaktable = b;
        this.breaktable.setEmulate(this);
        this.memBuffer = new EmulateMemoryStateBuffer(s, this.addrFactory.getDefaultAddressSpace().getMinAddress());
        this.uniqueBank = new UniqueMemoryBank(lang.getAddressFactory().getUniqueSpace(), lang.isBigEndian());
        this.memstate.setMemoryBank(this.uniqueBank);
        this.pseudoDisassembler = Disassembler.getDisassembler((Language)lang, (AddressFactory)this.addrFactory, (TaskMonitor)TaskMonitor.DUMMY, null);
        this.initInstuctionStateModifier();
    }

    public void dispose() {
        this.executionState = EmulateExecutionState.STOPPED;
    }

    private void initInstuctionStateModifier() {
        String classname = this.language.getProperty("emulateInstructionStateModifierClass");
        if (classname == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(classname);
            if (!EmulateInstructionStateModifier.class.isAssignableFrom(c)) {
                Msg.error((Object)this, (Object)("Language " + String.valueOf(this.language.getLanguageID()) + " does not specify a valid emulateInstructionStateModifierClass"));
                throw new RuntimeException(classname + " does not implement interface " + EmulateInstructionStateModifier.class.getName());
            }
            Class<?> instructionStateModifierClass = c;
            Constructor<?> constructor = instructionStateModifierClass.getConstructor(Emulate.class);
            this.instructionStateModifier = (EmulateInstructionStateModifier)constructor.newInstance(this);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Language " + String.valueOf(this.language.getLanguageID()) + " does not specify a valid emulateInstructionStateModifierClass"));
            throw new RuntimeException("Failed to instantiate " + classname + " for language " + String.valueOf(this.language.getLanguageID()), e);
        }
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean isInstructionStart() {
        return this.executionState == EmulateExecutionState.STOPPED || this.executionState == EmulateExecutionState.BREAKPOINT;
    }

    public EmulateExecutionState getExecutionState() {
        return this.executionState;
    }

    public Address getExecuteAddress() {
        return this.current_address;
    }

    public Address getLastExecuteAddress() {
        return this.last_execute_address;
    }

    public EmulateDisassemblerContext getNewDisassemblerContext() {
        return new EmulateDisassemblerContext((Language)this.language, this.getContextRegisterValue());
    }

    private int getInstructionLength(Instruction instr) throws InstructionDecodeException {
        int length = instr.getLength();
        for (int delaySlots = instr.getDelaySlotDepth(); delaySlots != 0; --delaySlots) {
            try {
                Address nextAddr = instr.getAddress().addNoWrap((long)instr.getLength());
                Instruction nextInstr = this.lastPseudoInstructionBlock.getInstructionAt(nextAddr);
                if (nextInstr == null) {
                    throw new InstructionDecodeException("Failed to parse delay slot instruction", nextAddr);
                }
                instr = nextInstr;
                length += instr.getLength();
                continue;
            }
            catch (AddressOverflowException e) {
                throw new InstructionDecodeException("Failed to parse delay slot instruction at end of address space", instr.getAddress());
            }
        }
        return length;
    }

    private PcodeOp[] emitPcode(Address addr) throws InstructionDecodeException {
        InstructionError error;
        this.memBuffer.setAddress(addr);
        this.pcode = null;
        this.pseudoInstruction = null;
        if (this.lastPseudoInstructionBlock != null) {
            this.pseudoInstruction = this.lastPseudoInstructionBlock.getInstructionAt(addr);
            if (this.pseudoInstruction != null) {
                this.instruction_length = this.getInstructionLength(this.pseudoInstruction);
                return this.pseudoInstruction.getPcode(false);
            }
            error = this.lastPseudoInstructionBlock.getInstructionConflict();
            if (error != null && addr.equals((Object)error.getInstructionAddress())) {
                throw new InstructionDecodeException(error.getConflictMessage(), addr);
            }
        }
        this.lastPseudoInstructionBlock = this.pseudoDisassembler.pseudoDisassembleBlock((MemBuffer)this.memBuffer, this.nextContextRegisterValue, 1);
        this.nextContextRegisterValue = null;
        if (this.lastPseudoInstructionBlock != null) {
            this.pseudoInstruction = this.lastPseudoInstructionBlock.getInstructionAt(addr);
            if (this.pseudoInstruction != null) {
                this.instruction_length = this.getInstructionLength(this.pseudoInstruction);
                return this.pseudoInstruction.getPcode(false);
            }
            error = this.lastPseudoInstructionBlock.getInstructionConflict();
            if (error != null && addr.equals((Object)error.getInstructionAddress())) {
                throw new InstructionDecodeException(error.getConflictMessage(), addr);
            }
        }
        throw new InstructionDecodeException("unknown reason", addr);
    }

    public RegisterValue getContextRegisterValue() {
        Register contextReg = this.language.getContextBaseRegister();
        if (contextReg == Register.NO_CONTEXT) {
            return null;
        }
        if (this.pseudoInstruction != null) {
            return this.pseudoInstruction.getRegisterValue(contextReg);
        }
        return this.nextContextRegisterValue;
    }

    public void setContextRegisterValue(RegisterValue regValue) {
        if (this.executionState != EmulateExecutionState.STOPPED && this.executionState != EmulateExecutionState.BREAKPOINT) {
            throw new IllegalStateException("emulator is not STOPPED");
        }
        if (regValue != null) {
            Register reg = regValue.getRegister();
            if (!reg.isProcessorContext()) {
                throw new IllegalArgumentException("processor context register required");
            }
            if (!reg.isBaseRegister()) {
                regValue = regValue.getBaseRegisterValue();
                reg = regValue.getRegister();
                if (this.nextContextRegisterValue != null) {
                    regValue = this.nextContextRegisterValue.combineValues(regValue);
                }
            }
            if (!reg.equals((Object)this.language.getContextBaseRegister())) {
                throw new IllegalArgumentException("invalid processor context register");
            }
        }
        this.nextContextRegisterValue = regValue;
        this.lastPseudoInstructionBlock = null;
        this.pseudoInstruction = null;
    }

    public void fallthruOp() {
        ++this.current_op;
        if (this.current_op >= this.pcode.length) {
            this.last_op = -1;
            this.setCurrentAddress(this.current_address.addWrap((long)this.instruction_length));
        }
    }

    public void executeConditionalBranch(PcodeOpRaw op) {
        Varnode condVar = op.getInput(1);
        boolean takeBranch = false;
        if (condVar.getSize() > 8) {
            takeBranch = !this.memstate.getBigInteger(condVar, false).equals(BigInteger.ZERO);
        } else {
            boolean bl = takeBranch = this.memstate.getValue(condVar) != 0L;
        }
        if (takeBranch) {
            this.executeBranch(op);
        } else {
            this.fallthruOp();
        }
    }

    public void executeBranch(PcodeOpRaw op) {
        Address destaddr = op.getInput(0).getAddress();
        if (destaddr.getAddressSpace().isConstantSpace()) {
            long id = destaddr.getOffset();
            this.current_op = (int)(id += (long)this.current_op);
            if (this.current_op == this.pcode.length) {
                this.fallthruOp();
            } else if (this.current_op < 0 || this.current_op >= this.pcode.length) {
                throw new LowlevelError("Bad intra-instruction branch");
            }
        } else {
            this.setCurrentAddress(destaddr);
        }
    }

    public void executeCallother(PcodeOpRaw op) throws UnimplementedCallOtherException {
        if (!(this.instructionStateModifier != null && this.instructionStateModifier.executeCallOther(op) || this.breaktable.doPcodeOpBreak(op))) {
            int userOp = (int)op.getInput(0).getOffset();
            String pcodeOpName = this.language.getUserDefinedOpName(userOp);
            throw new UnimplementedCallOtherException(op, pcodeOpName);
        }
        this.fallthruOp();
    }

    public void setExecuteAddress(Address addr) {
        if (addr != null && addr.equals((Object)this.current_address)) {
            return;
        }
        this.last_execute_address = null;
        this.setCurrentAddress(addr);
    }

    private void setCurrentAddress(Address addr) {
        this.current_address = addr;
        this.memstate.setValue(this.pcReg, this.current_address.getAddressableWordOffset());
        this.executionState = EmulateExecutionState.STOPPED;
        this.faultCause = null;
    }

    public void executeInstruction(boolean stopAtBreakpoint, TaskMonitor monitor) throws CancelledException, LowlevelError, InstructionDecodeException {
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        if (this.executionState == EmulateExecutionState.STOPPED) {
            if (this.last_execute_address == null && this.instructionStateModifier != null) {
                this.instructionStateModifier.initialExecuteCallback(this, this.current_address, this.nextContextRegisterValue);
            }
            if (this.breaktable.doAddressBreak(this.current_address) && stopAtBreakpoint) {
                this.executionState = EmulateExecutionState.BREAKPOINT;
                return;
            }
        } else {
            if (this.executionState == EmulateExecutionState.FAULT) {
                throw this.faultCause;
            }
            if (this.executionState != EmulateExecutionState.BREAKPOINT) {
                throw new LowlevelError("Already executing");
            }
        }
        try {
            this.executionState = EmulateExecutionState.INSTRUCTION_DECODE;
            if (this.language.numSections() == 0) {
                this.uniqueBank.clear();
            }
            this.pcode = this.emitPcode(this.current_address);
            this.last_execute_address = this.current_address;
            this.current_op = 0;
            if (this.pcode == null) {
                throw new InstructionDecodeException("Unexpected instruction pcode error", this.current_address);
            }
            this.executionState = EmulateExecutionState.EXECUTE;
            do {
                monitor.checkCancelled();
                this.executeCurrentOp();
            } while (this.executionState == EmulateExecutionState.EXECUTE);
            if (this.instructionStateModifier != null) {
                this.instructionStateModifier.postExecuteCallback(this, this.last_execute_address, this.pcode, this.last_op, this.current_address);
            }
        }
        catch (RuntimeException e) {
            this.faultCause = e;
            this.executionState = EmulateExecutionState.FAULT;
            throw e;
        }
    }

    public MemoryState getMemoryState() {
        return this.memstate;
    }

    private void executeCurrentOp() throws LowlevelError {
        if (this.current_op >= this.pcode.length) {
            this.fallthruOp();
            return;
        }
        this.last_op = this.current_op;
        PcodeOp op = this.pcode[this.current_op];
        if (op.getOpcode() == 0) {
            throw new UnimplementedInstructionException(this.current_address);
        }
        PcodeOpRaw raw = new PcodeOpRaw(op);
        OpBehavior behave = raw.getBehavior();
        if (behave == null) {
            throw new LowlevelError("Unsupported pcode op (opcode=" + op.getOpcode() + ", seq=" + String.valueOf(op.getSeqnum()) + ")");
        }
        if (behave instanceof UnaryOpBehavior) {
            UnaryOpBehavior unaryBehave = (UnaryOpBehavior)behave;
            Varnode in1var = op.getInput(0);
            Varnode outvar = op.getOutput();
            if (in1var.getSize() > 8 || outvar.getSize() > 8) {
                BigInteger in1 = this.memstate.getBigInteger(op.getInput(0), false);
                BigInteger out = unaryBehave.evaluateUnary(op.getOutput().getSize(), op.getInput(0).getSize(), in1);
                this.memstate.setValue(op.getOutput(), out);
            } else {
                long in1 = this.memstate.getValue(op.getInput(0));
                long out = unaryBehave.evaluateUnary(op.getOutput().getSize(), op.getInput(0).getSize(), in1);
                this.memstate.setValue(op.getOutput(), out);
            }
            this.fallthruOp();
        } else if (behave instanceof BinaryOpBehavior) {
            BinaryOpBehavior binaryBehave = (BinaryOpBehavior)behave;
            Varnode in1var = op.getInput(0);
            Varnode in2var = op.getInput(1);
            Varnode outvar = op.getOutput();
            if (in1var.getSize() > 8 || in2var.getSize() > 8 || outvar.getSize() > 8) {
                BigInteger in1 = this.memstate.getBigInteger(op.getInput(0), false);
                BigInteger in2 = this.memstate.getBigInteger(op.getInput(1), false);
                BigInteger out = binaryBehave.evaluateBinary(outvar.getSize(), op.getInput(0).getSize(), in1, in2);
                this.memstate.setValue(outvar, out);
            } else {
                long in1 = this.memstate.getValue(op.getInput(0));
                long in2 = this.memstate.getValue(op.getInput(1));
                long out = binaryBehave.evaluateBinary(outvar.getSize(), op.getInput(0).getSize(), in1, in2);
                this.memstate.setValue(outvar, out);
            }
            this.fallthruOp();
        } else {
            switch (behave.getOpCode()) {
                case 2: {
                    this.executeLoad(raw);
                    this.fallthruOp();
                    break;
                }
                case 3: {
                    this.executeStore(raw);
                    this.fallthruOp();
                    break;
                }
                case 4: {
                    this.executeBranch(raw);
                    break;
                }
                case 5: {
                    this.executeConditionalBranch(raw);
                    break;
                }
                case 6: {
                    this.executeBranchind(raw);
                    break;
                }
                case 7: {
                    this.executeCall(raw);
                    break;
                }
                case 8: {
                    this.executeCallind(raw);
                    break;
                }
                case 9: {
                    this.executeCallother(raw);
                    break;
                }
                case 10: {
                    this.executeBranchind(raw);
                    break;
                }
                case 60: {
                    this.executeMultiequal(raw);
                    this.fallthruOp();
                    break;
                }
                case 61: {
                    this.executeIndirect(raw);
                    this.fallthruOp();
                    break;
                }
                default: {
                    throw new LowlevelError("Unsupported op (opcode=" + behave.getOpCode() + ")");
                }
            }
        }
    }

    public void executeLoad(PcodeOpRaw op) {
        AddressSpace space = this.addrFactory.getAddressSpace((int)op.getInput(0).getAddress().getOffset());
        long offset = this.memstate.getValue(op.getInput(1));
        long byteOffset = space.truncateAddressableWordOffset(offset) * (long)space.getAddressableUnitSize();
        Varnode outvar = op.getOutput();
        if (outvar.getSize() > 8) {
            BigInteger res = this.memstate.getBigInteger(space, byteOffset, op.getOutput().getSize(), false);
            this.memstate.setValue(outvar, res);
        } else {
            long res = this.memstate.getValue(space, byteOffset, op.getOutput().getSize());
            this.memstate.setValue(op.getOutput(), res);
        }
    }

    public void executeStore(PcodeOpRaw op) {
        AddressSpace space = this.addrFactory.getAddressSpace((int)op.getInput(0).getAddress().getOffset());
        long offset = this.memstate.getValue(op.getInput(1));
        long byteOffset = space.truncateAddressableWordOffset(offset) * (long)space.getAddressableUnitSize();
        Varnode storedVar = op.getInput(2);
        if (storedVar.getSize() > 8) {
            BigInteger val = this.memstate.getBigInteger(storedVar, false);
            this.memstate.setValue(space, byteOffset, op.getInput(2).getSize(), val);
        } else {
            long val = this.memstate.getValue(storedVar);
            this.memstate.setValue(space, byteOffset, op.getInput(2).getSize(), val);
        }
    }

    public void executeBranchind(PcodeOpRaw op) {
        long offset = this.memstate.getValue(op.getInput(0));
        AddressSpace space = op.getAddress().getAddressSpace();
        this.setCurrentAddress(space.getTruncatedAddress(offset, true));
    }

    public void executeCall(PcodeOpRaw op) {
        this.setCurrentAddress(op.getInput(0).getAddress());
    }

    public void executeCallind(PcodeOpRaw op) {
        this.executeBranchind(op);
    }

    public void executeMultiequal(PcodeOpRaw op) {
        throw new LowlevelError("MULTIEQUAL appearing in unheritaged code?");
    }

    public void executeIndirect(PcodeOpRaw op) {
        throw new LowlevelError("INDIRECT appearing in unheritaged code?");
    }
}

