/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitSyntheticOp;
import ghidra.pcode.emu.jit.var.JitInputVar;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import java.util.List;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public record JitPhiOp(JitControlFlowModel.JitBlock block, JitOutVar out, BidiMap<JitControlFlowModel.BlockFlow, JitVal> options) implements JitDefOp,
JitSyntheticOp
{
    public JitPhiOp(JitControlFlowModel.JitBlock block, JitOutVar out) {
        this(block, out, (BidiMap<JitControlFlowModel.BlockFlow, JitVal>)new DualHashBidiMap());
    }

    public void addOption(JitControlFlowModel.BlockFlow flow, JitVal option) {
        this.options.put((Object)flow, (Object)option);
        option.addUse(this, 0);
    }

    public boolean hasInputOption() {
        return this.options.values().stream().anyMatch(opt -> opt instanceof JitInputVar);
    }

    public void addInputOption() {
        if (!this.hasInputOption()) {
            this.addOption(JitControlFlowModel.BlockFlow.entry(this.block), new JitInputVar(this.out.varnode()));
        }
    }

    @Override
    public void link() {
        JitDefOp.super.link();
        for (JitVal input : this.options.values()) {
            input.addUse(this, 0);
        }
    }

    @Override
    public void unlink() {
        JitDefOp.super.unlink();
        for (JitVal input : this.options.values()) {
            input.removeUse(this, 0);
        }
    }

    @Override
    public List<JitVal> inputs() {
        return List.copyOf(this.options.values());
    }

    @Override
    public JitTypeBehavior typeFor(int position) {
        if (position > this.options.size() || position < 0) {
            throw new AssertionError();
        }
        return this.optionType();
    }

    public JitTypeBehavior optionType() {
        return JitTypeBehavior.COPY;
    }

    @Override
    public JitTypeBehavior type() {
        return JitTypeBehavior.COPY;
    }
}

