/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class HighFunctionShellSymbol
extends HighSymbol {
    public HighFunctionShellSymbol(long id, String nm, Address addr, PcodeDataTypeManager manage) {
        super(id, nm, DataType.DEFAULT, true, true, manage);
        VariableStorage store;
        try {
            store = new VariableStorage((ProgramArchitecture)this.getProgram(), addr, 1);
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
        }
        MappedEntry entry = new MappedEntry(this, store, null);
        this.addMapEntry(entry);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_FUNCTION);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, this.getId());
        encoder.writeString(AttributeId.ATTRIB_NAME, this.name);
        String altName = this.dtmanage.getNameTransformer().simplify(this.name);
        if (!this.name.equals(altName)) {
            encoder.writeString(AttributeId.ATTRIB_LABEL, altName);
        }
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, 1L);
        AddressXML.encode(encoder, this.getStorage().getMinAddress());
        encoder.closeElement(ElementId.ELEM_FUNCTION);
    }
}

