/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.sourcemap.SourcePathTransformRecord;
import ghidra.program.model.sourcemap.SourcePathTransformer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class UserDataPathTransformer
implements SourcePathTransformer,
DomainObjectClosedListener {
    private Program program;
    private static final String USER_FILE_TRANSFORM_PREFIX = "USER_FILE_TRANSFORM_";
    private static final String USER_PATH_TRANSFORM_PREFIX = "USER_DIRECTORY_TRANSFORM_";
    private TreeMap<String, String> pathMap;
    private Map<String, String> fileMap;
    private ProgramUserData userData;
    private static final String FILE_SCHEME = "file";
    private static HexFormat hexFormat = HexFormat.of();
    private static HashMap<Program, UserDataPathTransformer> programsToTransformers = new HashMap();

    public static synchronized SourcePathTransformer getPathTransformer(Program program) {
        if (program == null) {
            return null;
        }
        return programsToTransformers.computeIfAbsent(program, p -> new UserDataPathTransformer((Program)p));
    }

    public static void validateDirectoryPath(String directory) {
        URI uri;
        if (StringUtils.isBlank((CharSequence)directory)) {
            throw new IllegalArgumentException("Blank directory path");
        }
        try {
            uri = new URI(FILE_SCHEME, null, directory, null).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        String normalizedPath = uri.getPath();
        if (!normalizedPath.endsWith("/")) {
            throw new IllegalArgumentException(directory + " is not a directory path");
        }
        if (!directory.equals(normalizedPath)) {
            throw new IllegalArgumentException(directory + " is not normalized");
        }
    }

    private UserDataPathTransformer(Program program) {
        this.program = program;
        this.userData = program.getProgramUserData();
        this.pathMap = new TreeMap(Collections.reverseOrder(UserDataPathTransformer::compareStrings));
        this.fileMap = new HashMap<String, String>();
        this.reloadMaps();
        program.addCloseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void domainObjectClosed(DomainObject dobj) {
        Class<UserDataPathTransformer> clazz = UserDataPathTransformer.class;
        synchronized (UserDataPathTransformer.class) {
            programsToTransformers.remove(this.program);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addFileTransform(SourceFile sourceFile, String path) {
        SourceFile validated = new SourceFile(path);
        if (!validated.getPath().equals(path)) {
            throw new IllegalArgumentException("path not normalized");
        }
        int txId = this.userData.startTransaction();
        String sourceString = this.getString(sourceFile);
        try {
            this.userData.setStringProperty(USER_FILE_TRANSFORM_PREFIX + sourceString, path);
        }
        finally {
            this.userData.endTransaction(txId);
        }
        this.fileMap.put(sourceString, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeFileTransform(SourceFile sourceFile) {
        int txId = this.userData.startTransaction();
        String sourceString = this.getString(sourceFile);
        try {
            this.userData.removeStringProperty(USER_FILE_TRANSFORM_PREFIX + this.getString(sourceFile));
        }
        finally {
            this.userData.endTransaction(txId);
        }
        this.fileMap.remove(sourceString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addDirectoryTransform(String sourceDir, String targetDir) {
        UserDataPathTransformer.validateDirectoryPath(sourceDir);
        UserDataPathTransformer.validateDirectoryPath(targetDir);
        int txId = this.userData.startTransaction();
        try {
            this.userData.setStringProperty(USER_PATH_TRANSFORM_PREFIX + sourceDir, targetDir);
        }
        finally {
            this.userData.endTransaction(txId);
        }
        this.pathMap.put(sourceDir, targetDir);
    }

    @Override
    public synchronized void removeDirectoryTransform(String sourceDir) {
        int txId = this.userData.startTransaction();
        try {
            this.userData.removeStringProperty(USER_PATH_TRANSFORM_PREFIX + sourceDir);
        }
        finally {
            this.userData.endTransaction(txId);
        }
        this.pathMap.remove(sourceDir);
    }

    @Override
    public synchronized String getTransformedPath(SourceFile sourceFile, boolean useExistingAsDefault) {
        String sourceFileString = this.getString(sourceFile);
        String mappedFile = this.fileMap.get(sourceFileString);
        if (mappedFile != null) {
            return mappedFile;
        }
        String path = sourceFile.getPath();
        for (String src : this.pathMap.keySet()) {
            if (!path.startsWith(src)) continue;
            return this.pathMap.get(src) + path.substring(src.length());
        }
        return useExistingAsDefault ? path : null;
    }

    @Override
    public synchronized List<SourcePathTransformRecord> getTransformRecords() {
        ArrayList<SourcePathTransformRecord> transformRecords = new ArrayList<SourcePathTransformRecord>();
        for (Map.Entry<String, String> entry : this.pathMap.entrySet()) {
            transformRecords.add(new SourcePathTransformRecord(entry.getKey(), null, entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.fileMap.entrySet()) {
            String sourceFileString = entry.getKey();
            transformRecords.add(new SourcePathTransformRecord(sourceFileString, this.getSourceFile(sourceFileString), entry.getValue()));
        }
        return transformRecords;
    }

    private static int compareStrings(String left, String right) {
        int rightLength;
        int leftLength = left.length();
        if (leftLength != (rightLength = right.length())) {
            return Integer.compare(leftLength, rightLength);
        }
        return StringUtils.compare((String)left, (String)right);
    }

    private void reloadMaps() {
        this.pathMap.clear();
        this.fileMap.clear();
        for (String key : this.userData.getStringPropertyNames()) {
            String value;
            if (key.startsWith(USER_PATH_TRANSFORM_PREFIX)) {
                value = this.userData.getStringProperty(key, null);
                if (StringUtils.isBlank((CharSequence)value)) {
                    throw new AssertionError((Object)("blank value for path " + key));
                }
                this.pathMap.put(key.substring(USER_PATH_TRANSFORM_PREFIX.length()), value);
                continue;
            }
            if (!key.startsWith(USER_FILE_TRANSFORM_PREFIX)) continue;
            value = this.userData.getStringProperty(key, null);
            if (StringUtils.isBlank((CharSequence)value)) {
                throw new AssertionError((Object)("blank value for file " + key));
            }
            this.fileMap.put(key.substring(USER_FILE_TRANSFORM_PREFIX.length()), value);
        }
    }

    private String getString(SourceFile sourceFile) {
        StringBuilder sb = new StringBuilder(sourceFile.getIdType().name());
        sb.append("#");
        sb.append(hexFormat.formatHex(sourceFile.getIdentifier()));
        sb.append("#");
        sb.append(sourceFile.getPath());
        return sb.toString();
    }

    private SourceFile getSourceFile(String sourceFileString) {
        int firstHash = sourceFileString.indexOf("#");
        SourceFileIdType type = SourceFileIdType.valueOf(sourceFileString.substring(0, firstHash));
        int secondHash = sourceFileString.indexOf("#", firstHash + 1);
        byte[] identifier = hexFormat.parseHex(sourceFileString.subSequence(firstHash + 1, secondHash));
        String path = sourceFileString.substring(secondHash + 1);
        return new SourceFile(path, type, identifier);
    }
}

