/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldFunctionDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class OldFunctionDBAdapterV0
extends OldFunctionDBAdapter {
    static final String V0_FUNCTIONS_TABLE_NAME = "Functions";
    static final int V0_RETURN_DATA_TYPE_ID_COL = 0;
    static final int V0_STACK_DEPTH_COL = 1;
    static final int V0_STACK_PARAM_OFFSET_COL = 2;
    static final int V0_STACK_RETURN_OFFSET_COL = 3;
    static final int V0_STACK_LOCAL_SIZE_COL = 4;
    protected Table table;

    OldFunctionDBAdapterV0(DBHandle dbHandle, AddressMap addrMap) throws VersionException {
        super(addrMap);
        this.table = dbHandle.getTable(V0_FUNCTIONS_TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: Functions");
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table Functions but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    public DBRecord getFunctionRecord(long functionKey) throws IOException {
        DBRecord oldRecord = this.table.getRecord(functionKey);
        return this.translateRecord(oldRecord);
    }

    public DBRecord translateRecord(DBRecord oldRecord) {
        if (oldRecord == null) {
            return null;
        }
        long entryPointKey = oldRecord.getKey();
        DBRecord newRecord = OldFunctionDBAdapter.FUNCTIONS_SCHEMA.createRecord(entryPointKey);
        newRecord.setLongValue(0, oldRecord.getLongValue(0));
        newRecord.setIntValue(1, oldRecord.getIntValue(1));
        newRecord.setIntValue(2, oldRecord.getIntValue(2));
        newRecord.setIntValue(3, oldRecord.getIntValue(3));
        newRecord.setIntValue(4, oldRecord.getIntValue(4));
        newRecord.setString(5, "");
        return newRecord;
    }

    @Override
    public RecordIterator iterateFunctionRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator());
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(V0_FUNCTIONS_TABLE_NAME);
    }

    class TranslatedRecordIterator
    implements RecordIterator {
        private RecordIterator it;

        TranslatedRecordIterator(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            DBRecord rec = this.it.next();
            return this.translate(rec);
        }

        public DBRecord previous() throws IOException {
            DBRecord rec = this.it.previous();
            return this.translate(rec);
        }

        private DBRecord translate(DBRecord oldRecord) {
            return OldFunctionDBAdapterV0.this.translateRecord(oldRecord);
        }
    }
}

