/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.function.FunctionTagManagerDB;
import ghidra.program.model.listing.FunctionTag;
import java.io.IOException;
import java.util.Objects;

public class FunctionTagDB
extends DatabaseObject
implements FunctionTag {
    private FunctionTagManagerDB mgr;
    private DBRecord record;

    public FunctionTagDB(FunctionTagManagerDB mgr, DBObjectCache<FunctionTagDB> cache, DBRecord record) {
        super(cache, record.getKey());
        this.mgr = mgr;
        this.record = record;
    }

    @Override
    public long getId() {
        return this.key;
    }

    @Override
    public void setComment(String comment) {
        this.mgr.lock.acquire();
        try {
            String oldValue;
            this.checkDeleted();
            if (comment == null) {
                comment = "";
            }
            if (!comment.equals(oldValue = this.record.getString(1))) {
                this.record.setString(1, comment);
                this.mgr.updateFunctionTag(this, oldValue, comment);
            }
        }
        catch (IOException e) {
            this.mgr.dbError(e);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public void setName(String name) {
        this.mgr.lock.acquire();
        try {
            String oldValue;
            this.checkDeleted();
            if (name == null) {
                name = "";
            }
            if (!name.equals(oldValue = this.record.getString(0))) {
                this.record.setString(0, name);
                this.mgr.updateFunctionTag(this, oldValue, name);
            }
        }
        catch (IOException e) {
            this.mgr.dbError(e);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public String getComment() {
        this.mgr.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(1);
            return string;
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public String getName() {
        this.mgr.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(0);
            return string;
        }
        finally {
            this.mgr.lock.release();
        }
    }

    DBRecord getRecord() {
        return this.record;
    }

    @Override
    protected boolean refresh() {
        return this.refresh(null);
    }

    @Override
    protected boolean refresh(DBRecord rec) {
        if (rec == null) {
            try {
                rec = this.mgr.getTagRecord(this.key);
            }
            catch (IOException e) {
                this.mgr.dbError(e);
            }
        }
        if (rec == null) {
            return false;
        }
        this.record = rec;
        return true;
    }

    @Override
    public void delete() {
        this.mgr.lock.acquire();
        try {
            if (this.checkIsValid()) {
                this.mgr.doDeleteTag(this);
            }
        }
        catch (IOException e) {
            this.mgr.dbError(e);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public int compareTo(FunctionTag otherTag) {
        int rc = this.getName().compareToIgnoreCase(otherTag.getName());
        if (rc != 0) {
            return rc;
        }
        return this.getComment().compareToIgnoreCase(otherTag.getComment());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getComment() == null ? 0 : this.getComment().hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionTag)) {
            return false;
        }
        FunctionTag other = (FunctionTag)obj;
        if (!Objects.equals(this.getComment(), other.getComment())) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return this.getName();
    }
}

