/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBLongIterator;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import java.io.IOException;

public class DataKeyIterator
implements DataIterator {
    private CodeManager codeMgr;
    private DBLongIterator it;
    private Data nextCu;
    private AddressMap addrMap;

    public DataKeyIterator(CodeManager codeMgr, AddressMap addrMap, DBLongIterator it) {
        this.codeMgr = codeMgr;
        this.addrMap = addrMap;
        this.it = it;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.nextCu == null) {
            this.findNext();
        }
        return this.nextCu != null;
    }

    @Override
    public Data next() {
        if (this.hasNext()) {
            Data ret = this.nextCu;
            this.nextCu = null;
            return ret;
        }
        return null;
    }

    private void findNext() {
        try {
            while (this.nextCu == null && this.it.hasNext()) {
                long addr = this.it.next();
                this.nextCu = this.codeMgr.getDataAt(this.addrMap.decodeAddress(addr), addr);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

