/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.PseudoInstruction;
import ghidra.program.model.address.AddressSetView;

public class RepeatInstructionByteTracker {
    private AddressSetView repeatPatternLimitIgnoredRegion;
    private int repeatPatternLimit;
    private int repeatPatternCnt;
    private byte repeatByteValue;

    public RepeatInstructionByteTracker(int repeatPatternLimit, AddressSetView repeatPatternLimitIgnoredRegion) {
        this.repeatPatternLimit = repeatPatternLimit;
        this.repeatPatternLimitIgnoredRegion = repeatPatternLimitIgnoredRegion;
    }

    public void reset() {
        this.repeatPatternCnt = 0;
    }

    public boolean exceedsRepeatBytePattern(PseudoInstruction inst) {
        if (this.repeatPatternLimit <= 0) {
            return false;
        }
        if (this.repeatPatternLimitIgnoredRegion != null && this.repeatPatternLimitIgnoredRegion.contains(inst.getAddress())) {
            this.repeatPatternCnt = 0;
            return false;
        }
        Byte repeatedByte = inst.getRepeatedByte();
        if (repeatedByte == null) {
            this.repeatPatternCnt = 0;
        } else if (this.repeatByteValue == repeatedByte) {
            if (++this.repeatPatternCnt > this.repeatPatternLimit) {
                this.repeatPatternCnt = 0;
                return true;
            }
        } else {
            this.repeatByteValue = repeatedByte;
            this.repeatPatternCnt = 1;
        }
        return false;
    }

    public void setRepeatPatternLimit(int maxInstructions) {
        this.repeatPatternLimit = maxInstructions;
    }

    public void setRepeatPatternLimitIgnored(AddressSetView set) {
        this.repeatPatternLimitIgnoredRegion = set;
    }
}

