/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.schema;

import ghidra.lifecycle.Unfinished;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.TraceExecutionState;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.schema.DefaultSchemaContext;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum PrimitiveTraceObjectSchema implements TraceObjectSchema
{
    ANY(new Class[]{Object.class}){

        @Override
        public TraceObjectSchema.SchemaName getDefaultElementSchema() {
            return OBJECT.getName();
        }

        @Override
        public TraceObjectSchema.AttributeSchema getDefaultAttributeSchema() {
            return TraceObjectSchema.AttributeSchema.DEFAULT_ANY;
        }

        @Override
        public boolean isAssignableFrom(TraceObjectSchema that) {
            return true;
        }
    }
    ,
    OBJECT(new Class[]{TraceObject.class}){

        @Override
        public TraceObjectSchema.SchemaName getDefaultElementSchema() {
            return OBJECT.getName();
        }

        @Override
        public TraceObjectSchema.AttributeSchema getDefaultAttributeSchema() {
            return TraceObjectSchema.AttributeSchema.DEFAULT_ANY;
        }

        @Override
        public boolean isAssignableFrom(TraceObjectSchema that) {
            return true;
        }
    }
    ,
    TYPE(Class.class),
    VOID(Void.class, Void.TYPE),
    BOOL(Boolean.class, Boolean.TYPE),
    BYTE(Byte.class, Byte.TYPE),
    SHORT(Short.class, Short.TYPE),
    INT(Integer.class, Integer.TYPE),
    LONG(Long.class, Long.TYPE),
    STRING(String.class),
    ADDRESS(Address.class),
    RANGE(AddressRange.class),
    EXECUTION_STATE(TraceExecutionState.class),
    MAP_PARAMETERS(Unfinished.class),
    CHAR(Character.class, Character.TYPE),
    BOOL_ARR(boolean[].class),
    BYTE_ARR(byte[].class),
    CHAR_ARR(char[].class),
    SHORT_ARR(short[].class),
    INT_ARR(int[].class),
    LONG_ARR(long[].class),
    STRING_ARR(String[].class);

    private final TraceObjectSchema.SchemaName name = new TraceObjectSchema.SchemaName(this.name());
    private final List<Class<?>> types;

    public static PrimitiveTraceObjectSchema schemaForPrimitive(Class<?> cls) {
        for (PrimitiveTraceObjectSchema schema : PrimitiveTraceObjectSchema.values()) {
            if (!schema.getTypes().contains(cls)) continue;
            return schema;
        }
        return null;
    }

    public static TraceObjectSchema.SchemaName nameForPrimitive(Class<?> cls) {
        PrimitiveTraceObjectSchema schema = PrimitiveTraceObjectSchema.schemaForPrimitive(cls);
        return schema == null ? null : schema.getName();
    }

    private PrimitiveTraceObjectSchema(Class<?> ... types) {
        this.types = List.of(types);
    }

    @Override
    public SchemaContext getContext() {
        return MinimalSchemaContext.INSTANCE;
    }

    @Override
    public TraceObjectSchema.SchemaName getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.types.get(0);
    }

    public List<Class<?>> getTypes() {
        return this.types;
    }

    @Override
    public Set<Class<? extends TraceObjectInterface>> getInterfaces() {
        return Set.of();
    }

    @Override
    public boolean isCanonicalContainer() {
        return false;
    }

    @Override
    public Map<String, TraceObjectSchema.SchemaName> getElementSchemas() {
        return Map.of();
    }

    @Override
    public TraceObjectSchema.SchemaName getDefaultElementSchema() {
        return VOID.getName();
    }

    @Override
    public Map<String, TraceObjectSchema.AttributeSchema> getAttributeSchemas() {
        return Map.of();
    }

    @Override
    public Map<String, String> getAttributeAliases() {
        return Map.of();
    }

    @Override
    public TraceObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return TraceObjectSchema.AttributeSchema.DEFAULT_VOID;
    }

    @Override
    public PathFilter searchFor(Class<? extends TraceObjectInterface> type, boolean requireCanonical) {
        return PathFilter.NONE;
    }

    @Override
    public KeyPath searchForCanonicalContainer(Class<? extends TraceObjectInterface> type) {
        return null;
    }

    @Override
    public KeyPath searchForSuitable(Class<? extends TraceObjectInterface> type, KeyPath path) {
        return null;
    }

    public static final class MinimalSchemaContext
    extends DefaultSchemaContext {
        public static final SchemaContext INSTANCE = new MinimalSchemaContext();
    }
}

