/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.path;

import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathPattern;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class KeyPath
implements Comparable<KeyPath>,
Iterable<String> {
    public static final KeyPath ROOT = new KeyPath(new String[0]);
    final String[] keys;
    private final int hash;

    public static String makeIndex(long i) {
        return Long.toString(i);
    }

    public static boolean isIndex(String key) {
        return key == null ? false : key.startsWith("[") && key.endsWith("]");
    }

    public static boolean isName(String key) {
        return key == null ? false : !KeyPath.isIndex(key);
    }

    public static String parseIndex(String key) {
        if (KeyPath.isIndex(key)) {
            return key.substring(1, key.length() - 1);
        }
        throw new IllegalArgumentException("Index keys must be of the form '[index]'. Got " + key);
    }

    public static String parseIfIndex(String key) {
        if (KeyPath.isIndex(key)) {
            return key.substring(1, key.length() - 1);
        }
        return key;
    }

    public static String makeKey(String index) {
        return "[" + index + "]";
    }

    public static KeyPath of(List<String> keyList) {
        return new KeyPath((String[])keyList.toArray(String[]::new));
    }

    public static KeyPath of(Stream<String> keyStream) {
        return new KeyPath((String[])keyStream.toArray(String[]::new));
    }

    public static KeyPath of(String ... keys) {
        return new KeyPath(Arrays.copyOf(keys, keys.length));
    }

    public static KeyPath parse(String path) {
        return new PathParser(path, "\\.").parse();
    }

    KeyPath(String ... keys) {
        this.keys = keys;
        this.hash = Objects.hash(keys);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(KeyPath that) {
        if (this == that) {
            return 0;
        }
        return PathComparator.KEYED.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyPath)) {
            return false;
        }
        KeyPath that = (KeyPath)obj;
        return Arrays.equals(this.keys, that.keys);
    }

    public int size() {
        return this.keys.length;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < KeyPath.this.keys.length;
            }

            @Override
            public String next() {
                return KeyPath.this.keys[this.i++];
            }
        };
    }

    public String key(int i) {
        return this.keys[i];
    }

    public List<String> toList() {
        return List.of(this.keys);
    }

    public boolean containsWildcard() {
        for (String k : this.keys) {
            if (!PathPattern.isWildcard(k)) continue;
            return true;
        }
        return false;
    }

    public int countWildcards() {
        int count = 0;
        for (String k : this.keys) {
            if (!PathPattern.isWildcard(k)) continue;
            ++count;
        }
        return count;
    }

    public boolean isRoot() {
        return this.keys.length == 0;
    }

    public KeyPath key(String name) {
        String[] keys = Arrays.copyOf(this.keys, this.keys.length + 1);
        keys[this.keys.length] = name;
        return new KeyPath(keys);
    }

    public String key() {
        if (this.keys.length == 0) {
            return null;
        }
        return this.keys[this.keys.length - 1];
    }

    public KeyPath index(long index) {
        return this.index(KeyPath.makeIndex(index));
    }

    public KeyPath index(String index) {
        return this.extend(KeyPath.makeKey(index));
    }

    public String index() {
        String key = this.key();
        return key == null ? null : KeyPath.parseIndex(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String k : this.keys) {
            if (!KeyPath.isIndex(k) && !first) {
                sb.append(".");
            }
            first = false;
            sb.append(k);
        }
        return sb.toString();
    }

    public KeyPath parent() {
        return this.parent(1);
    }

    public KeyPath parent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n<0");
        }
        if (this.keys.length < n) {
            return null;
        }
        return new KeyPath(Arrays.copyOf(this.keys, this.keys.length - n));
    }

    public KeyPath extend(KeyPath sub) {
        return this.extend(sub.keys);
    }

    public KeyPath extend(String ... subKeys) {
        String[] keys = Arrays.copyOf(this.keys, this.keys.length + subKeys.length);
        System.arraycopy(subKeys, 0, keys, this.keys.length, subKeys.length);
        return new KeyPath(keys);
    }

    public Stream<KeyPath> streamMatchingAncestry(PathFilter filter) {
        Stream<KeyPath> ancestry;
        if (!filter.ancestorMatches(this, false)) {
            return Stream.of(new KeyPath[0]);
        }
        Stream<KeyPath> stream = ancestry = this.isRoot() ? Stream.of(new KeyPath[0]) : this.parent().streamMatchingAncestry(filter);
        if (filter.matches(this)) {
            return Stream.concat(Stream.of(this), ancestry);
        }
        return ancestry;
    }

    public boolean isAncestor(KeyPath successor) {
        if (this.keys.length > successor.keys.length) {
            return false;
        }
        int len = this.keys.length;
        return Arrays.equals(this.keys, 0, len, successor.keys, 0, len);
    }

    public KeyPath relativize(KeyPath successor) {
        if (!this.isAncestor(successor)) {
            throw new IllegalArgumentException("this is not an ancestor to successor");
        }
        return new KeyPath(Arrays.copyOfRange(successor.keys, this.keys.length, successor.keys.length));
    }

    public static class PathParser {
        protected static final Pattern LBRACKET = Pattern.compile("\\[");
        protected static final Pattern RBRACKET = Pattern.compile("\\]");
        protected static final Pattern BRACKETED = Pattern.compile("\\[.*?\\]");
        protected static final Pattern LPAREN = Pattern.compile("\\(");
        protected static final Pattern RPAREN = Pattern.compile("\\)");
        protected final CharBuffer buf;
        protected final Pattern sep;
        protected final List<String> result = new ArrayList<String>();

        public PathParser(CharSequence path, String sepRE) {
            this.buf = CharBuffer.wrap(path);
            this.sep = Pattern.compile(sepRE);
        }

        protected String match(Pattern pat) {
            Matcher mat = pat.matcher(this.buf);
            if (!mat.lookingAt()) {
                throw new IllegalArgumentException("Expecting " + String.valueOf(pat) + ", but had " + String.valueOf(this.buf));
            }
            String tok = mat.group();
            int length = mat.end() - mat.start();
            this.buf.position(this.buf.position() + length);
            return tok;
        }

        protected void advanceParenthesized() {
            while (this.buf.hasRemaining()) {
                if (RPAREN.matcher(this.buf).lookingAt()) {
                    this.buf.get();
                    break;
                }
                if (LPAREN.matcher(this.buf).lookingAt()) {
                    this.buf.get();
                    this.advanceParenthesized();
                    continue;
                }
                this.buf.get();
            }
        }

        protected String parseName() {
            int p = this.buf.position();
            while (this.buf.hasRemaining() && !this.sep.matcher(this.buf).lookingAt() && !LBRACKET.matcher(this.buf).lookingAt()) {
                if (LPAREN.matcher(this.buf).lookingAt()) {
                    this.buf.get();
                    this.advanceParenthesized();
                    continue;
                }
                this.buf.get();
            }
            int e = this.buf.position();
            this.buf.position(p);
            String tok = this.buf.subSequence(0, e - p).toString();
            this.buf.position(e);
            return tok;
        }

        protected String parseNext() {
            if (this.sep.matcher(this.buf).lookingAt()) {
                this.match(this.sep);
                return this.parseName();
            }
            if (LBRACKET.matcher(this.buf).lookingAt()) {
                return this.match(BRACKETED);
            }
            throw new IllegalArgumentException("Expected " + String.valueOf(this.sep) + " or " + String.valueOf(LBRACKET) + ", but had " + String.valueOf(this.buf));
        }

        public KeyPath parse() {
            String first = this.parseName();
            if (first.length() != 0) {
                this.result.add(first);
            }
            while (this.buf.hasRemaining()) {
                this.result.add(this.parseNext());
            }
            return KeyPath.of(this.result);
        }
    }

    public static enum PathComparator implements Comparator<KeyPath>
    {
        KEYED{

            @Override
            public int compare(KeyPath o1, KeyPath o2) {
                int min = Math.min(o1.size(), o2.size());
                for (int i = 0; i < min; ++i) {
                    String e2;
                    String e1 = o1.key(i);
                    int c = e1.compareTo(e2 = o2.key(i));
                    if (c == 0) continue;
                    return c;
                }
                return Integer.compare(o1.size(), o2.size());
            }
        }
        ,
        LONGEST_FIRST{

            @Override
            public int compare(KeyPath o1, KeyPath o2) {
                int c = Integer.compare(o2.size(), o1.size());
                if (c != 0) {
                    return c;
                }
                return KEYED.compare(o1, o2);
            }
        };

    }

    public static enum KeyComparator implements Comparator<String>
    {
        ATTRIBUTE{

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        }
        ,
        ELEMENT{

            @Override
            public int compare(String o1, String o2) {
                String[] p1 = o1.split(",");
                String[] p2 = o2.split(",");
                int min = Math.min(p1.length, p2.length);
                for (int i = 0; i < min; ++i) {
                    int c = ELEMENT_DIM.compare(p1[i], p2[i]);
                    if (c == 0) continue;
                    return c;
                }
                return Integer.compare(p1.length, p2.length);
            }
        }
        ,
        ELEMENT_DIM{

            @Override
            public int compare(String o1, String o2) {
                Long l1 = null;
                Long l2 = null;
                try {
                    l1 = Long.parseLong(o1, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    l2 = Long.parseLong(o2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (l1 != null && l2 != null) {
                    return l1.compareTo(l2);
                }
                if (l1 != null) {
                    return -1;
                }
                if (l2 != null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        }
        ,
        CHILD{

            @Override
            public int compare(String o1, String o2) {
                boolean ii2;
                boolean ii1 = o1.startsWith("[") && o1.endsWith("]");
                boolean bl = ii2 = o2.startsWith("[") && o2.endsWith("]");
                if (ii1 && ii2) {
                    return ELEMENT.compare(o1.substring(1, o1.length() - 1), o2.substring(1, o2.length() - 1));
                }
                if (ii1) {
                    return -1;
                }
                if (ii2) {
                    return 1;
                }
                return ATTRIBUTE.compare(o1, o2);
            }
        };

    }
}

