/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target;

import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.schema.TraceObjectSchema;

public interface TraceObjectValue {
    public Trace getTrace();

    public TraceObject getParent();

    public String getEntryKey();

    default public boolean hasEntryKey(String keyOrAlias) {
        TraceObject parent = this.getParent();
        if (parent == null) {
            return this.getEntryKey().equals(keyOrAlias);
        }
        return this.getEntryKey().equals(parent.getSchema().checkAliasedAttribute(keyOrAlias));
    }

    public KeyPath getCanonicalPath();

    public Object getValue();

    default public <T> T castValue() {
        return (T)this.getValue();
    }

    public TraceObject getChild();

    public boolean isObject();

    public boolean isCanonical();

    default public TraceObjectSchema getTargetSchema() {
        return this.getParent().getSchema().getChildSchema(this.getEntryKey());
    }

    public void setLifespan(Lifespan var1);

    public void setLifespan(Lifespan var1, TraceObject.ConflictResolution var2);

    public Lifespan getLifespan();

    public void setMinSnap(long var1);

    public long getMinSnap();

    public void setMaxSnap(long var1);

    public long getMaxSnap();

    public void delete();

    public boolean isDeleted();

    public TraceObjectValue truncateOrDelete(Lifespan var1);

    default public boolean isHidden() {
        TraceObject parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getSchema().isHidden(this.getEntryKey());
    }
}

