/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectDBFieldCodec;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.DBTraceObjectValueRStarTree;
import ghidra.trace.database.target.ImmutableValueBox;
import ghidra.trace.database.target.ImmutableValueShape;
import ghidra.trace.database.target.TraceObjectValueStorage;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.database.target.ValueShape;
import ghidra.trace.database.target.ValueTriple;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.spatial.DBTreeDataRecord;
import java.io.IOException;
import java.util.Objects;

@DBAnnotatedObjectInfo(version=1)
public class DBTraceObjectValueData
extends DBTreeDataRecord<ValueShape, ValueBox, DBTraceObjectValueData>
implements TraceObjectValueStorage,
ValueShape {
    static final String TABLE_NAME = "ObjectValue";
    static final String PARENT_COLUMN_NAME = "Parent";
    static final String OBJ_PARENT_COLUMN_NAME = "ObjParent";
    static final String ENTRY_KEY_COLUMN_NAME = "EntryKey";
    static final String MIN_SNAP_COLUMN_NAME = "MinSnap";
    static final String MAX_SNAP_COLUMN_NAME = "MaxSnap";
    static final String CHILD_COLUMN_NAME = "Child";
    static final String PRIMITIVE_COLUMN_NAME = "Primitive";
    @DBAnnotatedColumn(value="Parent")
    static DBObjectColumn PARENT_COLUMN;
    @DBAnnotatedColumn(value="ObjParent")
    static DBObjectColumn OBJ_PARENT_COLUMN;
    @DBAnnotatedColumn(value="EntryKey")
    static DBObjectColumn ENTRY_KEY_COLUMN;
    @DBAnnotatedColumn(value="MinSnap")
    static DBObjectColumn MIN_SNAP_COLUMN;
    @DBAnnotatedColumn(value="MaxSnap")
    static DBObjectColumn MAX_SNAP_COLUMN;
    @DBAnnotatedColumn(value="Child")
    static DBObjectColumn CHILD_COLUMN;
    @DBAnnotatedColumn(value="Primitive")
    static DBObjectColumn PRIMITIVE_COLUMN;
    @DBAnnotatedField(column="Parent", indexed=true)
    private long parentKey;
    @DBAnnotatedField(column="ObjParent", codec=DBTraceObjectDBFieldCodec.class)
    private DBTraceObject objParent;
    @DBAnnotatedField(column="EntryKey")
    private String entryKey;
    @DBAnnotatedField(column="MinSnap")
    private long minSnap;
    @DBAnnotatedField(column="MaxSnap")
    private long maxSnap;
    @DBAnnotatedField(column="Child", indexed=true, codec=DBTraceObjectDBFieldCodec.class)
    private DBTraceObject child;
    @DBAnnotatedField(column="Primitive", codec=DBCachedObjectStoreFactory.VariantDBFieldCodec.class)
    private Object primitive;
    protected final DBTraceObjectManager manager;
    protected final DBTraceObjectValueRStarTree tree;
    protected ValueBox bounds;
    protected Lifespan lifespan;
    protected Address address;
    protected AddressRange range;
    private DBTraceObjectValue wrapper;

    public DBTraceObjectValueData(DBTraceObjectManager manager, DBTraceObjectValueRStarTree tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
        this.tree = tree;
    }

    void doSetPrimitive(Object primitive) {
        if (primitive instanceof TraceObject) {
            throw new AssertionError();
        }
        if (primitive instanceof Address) {
            Address address;
            this.address = address = (Address)primitive;
            this.range = null;
            this.primitive = DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)address);
        } else if (primitive instanceof AddressRange) {
            AddressRange range = (AddressRange)primitive;
            this.address = null;
            this.range = range;
            this.primitive = DBCachedObjectStoreFactory.RecRange.fromRange((AddressRange)range);
        } else {
            this.address = null;
            this.range = null;
            this.primitive = primitive;
        }
        this.update(PRIMITIVE_COLUMN);
    }

    protected long getObjParentKey() {
        return this.objParent == null ? -1L : this.objParent.getKey();
    }

    protected long getObjChildKey() {
        return this.child == null ? -1L : this.child.getKey();
    }

    @Override
    public int getAddressSpaceId() {
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress addr = (DBCachedObjectStoreFactory.RecAddress)object;
            return addr.spaceId();
        }
        object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecRange) {
            DBCachedObjectStoreFactory.RecRange rng = (DBCachedObjectStoreFactory.RecRange)object;
            return rng.spaceId();
        }
        return -1;
    }

    @Override
    public long getMinAddressOffset() {
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress addr = (DBCachedObjectStoreFactory.RecAddress)object;
            return addr.offset();
        }
        object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecRange) {
            DBCachedObjectStoreFactory.RecRange rng = (DBCachedObjectStoreFactory.RecRange)object;
            return rng.min();
        }
        return 0L;
    }

    @Override
    public long getMaxAddressOffset() {
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress addr = (DBCachedObjectStoreFactory.RecAddress)object;
            return addr.offset();
        }
        object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecRange) {
            DBCachedObjectStoreFactory.RecRange rng = (DBCachedObjectStoreFactory.RecRange)object;
            return rng.max();
        }
        return 0L;
    }

    protected void updateBounds() {
        long objParentKey = this.getObjParentKey();
        long objChildKey = this.getObjChildKey();
        int spaceId = this.getAddressSpaceId();
        this.bounds = new ImmutableValueBox(new ValueTriple(objParentKey, objChildKey, this.entryKey, this.minSnap, new DBCachedObjectStoreFactory.RecAddress(spaceId, this.getMinAddressOffset())), new ValueTriple(objParentKey, objChildKey, this.entryKey, this.maxSnap, new DBCachedObjectStoreFactory.RecAddress(spaceId, this.getMaxAddressOffset())));
    }

    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.updateBounds();
        this.lifespan = Lifespan.span(this.minSnap, this.maxSnap);
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress address = (DBCachedObjectStoreFactory.RecAddress)object;
            this.address = address.toAddress(this.manager.trace.getBaseAddressFactory());
            this.range = null;
        } else {
            object = this.primitive;
            if (object instanceof DBCachedObjectStoreFactory.RecRange) {
                DBCachedObjectStoreFactory.RecRange range = (DBCachedObjectStoreFactory.RecRange)object;
                this.address = null;
                this.range = range.toRange(this.manager.trace.getBaseAddressFactory());
            } else {
                this.address = null;
                this.range = null;
            }
        }
    }

    @Override
    public DBTraceObject getParent() {
        return this.objParent;
    }

    @Override
    public String getEntryKey() {
        return this.entryKey;
    }

    @Override
    public Object getValue() {
        if (this.child != null) {
            return this.child;
        }
        if (this.address != null) {
            return this.address;
        }
        if (this.range != null) {
            return this.range;
        }
        return this.child != null ? this.child : this.primitive;
    }

    @Override
    public DBTraceObject getChild() {
        return (DBTraceObject)this.getValue();
    }

    @Override
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    protected boolean shapeEquals(ValueShape shape) {
        if (this.objParent != shape.getParent()) {
            return false;
        }
        if (!Objects.equals(this.entryKey, shape.getEntryKey())) {
            return false;
        }
        return Objects.equals(this.lifespan, shape.getLifespan());
    }

    protected void setRecordValue(DBTraceObjectValueData value) {
    }

    protected DBTraceObjectValueData getRecordValue() {
        return this;
    }

    public ValueShape getShape() {
        return this;
    }

    public ValueBox getBounds() {
        return this.bounds;
    }

    public void setShape(ValueShape shape) {
        this.objParent = shape.getParent();
        this.child = shape.getChild();
        this.entryKey = shape.getEntryKey();
        this.minSnap = shape.getLifespan().lmin();
        this.maxSnap = shape.getLifespan().lmax();
        this.update(new DBObjectColumn[]{OBJ_PARENT_COLUMN, CHILD_COLUMN, ENTRY_KEY_COLUMN, MIN_SNAP_COLUMN, MAX_SNAP_COLUMN});
        this.lifespan = shape.getLifespan();
        this.bounds = (ValueBox)shape.getBounds();
    }

    public long getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(long parentKey) {
        this.parentKey = parentKey;
        this.update(PARENT_COLUMN);
    }

    public String description() {
        return new ImmutableValueShape(this.getShape()).toString();
    }

    @Override
    public DBTraceObjectManager getManager() {
        return this.manager;
    }

    @Override
    public DBTraceObject getChildOrNull() {
        return this.child;
    }

    @Override
    public void doSetLifespan(Lifespan lifespan) {
        DBTraceObjectValueRStarTree tree = this.tree;
        tree.doUnparentEntry(this);
        this.minSnap = lifespan.lmin();
        this.maxSnap = lifespan.lmax();
        this.update(MIN_SNAP_COLUMN, MAX_SNAP_COLUMN);
        this.lifespan = lifespan;
        this.updateBounds();
        tree.doInsertDataEntry(this);
    }

    @Override
    public void doDelete() {
        this.manager.doDeleteValue(this);
    }

    @Override
    public DBTraceObjectValue getWrapper() {
        if (this.wrapper == null) {
            this.wrapper = new DBTraceObjectValue(this.manager, this);
        }
        return this.wrapper;
    }

    void setWrapper(DBTraceObjectValue wrapper) {
        if (this.wrapper != null) {
            throw new AssertionError();
        }
        this.wrapper = wrapper;
    }
}

