/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.Enum;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.symbol.DBTraceEquate;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.symbol.TraceEquateReference;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Collection;
import java.util.List;

public class DBTraceProgramViewEquate
implements Equate {
    protected final DBTraceProgramView program;
    protected final DBTraceEquate equate;

    public DBTraceProgramViewEquate(DBTraceProgramView program, DBTraceEquate equate) {
        this.program = program;
        this.equate = equate;
    }

    public String getName() {
        return this.equate.getName();
    }

    public String getDisplayName() {
        return this.equate.getDisplayName();
    }

    public long getValue() {
        return this.equate.getValue();
    }

    public String getDisplayValue() {
        return this.equate.getDisplayValue();
    }

    public int getReferenceCount() {
        return this.equate.getReferenceCount();
    }

    public void addReference(Address refAddr, int opndPosition) {
        this.equate.addReference(Lifespan.nowOn(this.program.snap), null, refAddr, opndPosition);
    }

    public void addReference(long dynamicHash, Address refAddr) {
        throw new UnsupportedOperationException();
    }

    public void renameEquate(String newName) throws DuplicateNameException, InvalidInputException {
        this.equate.setName(newName);
    }

    public EquateReference[] getReferences() {
        Collection<? extends TraceEquateReference> refs = this.equate.getReferences();
        return refs.toArray(new EquateReference[refs.size()]);
    }

    public List<EquateReference> getReferences(Address refAddr) {
        return this.equate.getReferences(refAddr);
    }

    public void removeReference(Address refAddr, int opndPosition) {
        TraceEquateReference ref = this.equate.getReference(this.program.snap, null, refAddr, opndPosition);
        if (ref == null) {
            return;
        }
        ref.delete();
    }

    public void removeReference(long dynamicHash, Address refAddr) {
        throw new UnsupportedOperationException();
    }

    public boolean isValidUUID() {
        return this.equate.hasValidEnum();
    }

    public boolean isEnumBased() {
        return this.equate.isEnumBased();
    }

    public UniversalID getEnumUUID() {
        Enum dt = this.equate.getEnum();
        return dt == null ? null : dt.getUniversalID();
    }
}

