/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import ghidra.app.plugin.core.debug.client.tracermi.DefaultMemoryMapper;
import ghidra.app.plugin.core.debug.client.tracermi.DefaultRegisterMapper;
import ghidra.dbg.jdi.rmi.jpda.JdiConnector;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import java.util.HashMap;

public class JdiArch {
    private JdiConnector connector;
    private LanguageID langID;
    private Language language;
    private final LanguageService languageService = DefaultLanguageService.getLanguageService();

    public JdiArch(JdiConnector connector) {
        this.connector = connector;
    }

    public String getArch() {
        HashMap<String, String> env = new HashMap<String, String>(this.connector.getEnv());
        String arch = "JVM";
        if (env.containsKey("OPT_ARCH")) {
            arch = (String)env.get("OPT_ARCH");
        }
        return arch.equals("Dalvik") ? "Dalvik" : "JVM";
    }

    public String getEndian() {
        return "big";
    }

    public String getOSABI() {
        HashMap<String, String> env = new HashMap<String, String>(this.connector.getEnv());
        String arch = "JVM";
        if (env.containsKey("OPT_ARCH")) {
            arch = (String)env.get("OPT_ARCH");
        }
        return arch.equals("Dalvik") ? "Dalvik:LE:32:default" : "JVM:BE:32:default";
    }

    public LanguageID computeGhidraLanguage() {
        return new LanguageID(this.getOSABI());
    }

    public CompilerSpecID computeGhidraCompiler(LanguageID id) {
        return new CompilerSpecID("default");
    }

    public void computeGhidraLcsp() {
        this.langID = this.computeGhidraLanguage();
        try {
            this.language = this.languageService.getLanguage(this.langID);
        }
        catch (LanguageNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public DefaultMemoryMapper computeMemoryMapper() {
        if (this.langID == null) {
            this.computeGhidraLcsp();
        }
        return new DefaultMemoryMapper(this.langID);
    }

    public DefaultRegisterMapper computeRegisterMapper() {
        if (this.langID == null) {
            this.computeGhidraLcsp();
        }
        return new DefaultRegisterMapper(this.langID);
    }

    public Language getLanguage() {
        return this.language;
    }
}

