/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager.impl;

public enum DebugStatus {
    NO_CHANGE(false, null, 13),
    GO(true, 1, 10),
    STEP_OVER(true, 1, 7),
    STEP_INTO(true, 1, 5),
    BREAK(false, 1, 0),
    NO_DEBUGGEE(true, null, 1),
    STEP_BRANCH(true, null, 6),
    IGNORE_EVENT(false, null, 11),
    RESTART_REQUESTED(true, null, 12),
    OUT_OF_SYNC(false, null, 2),
    WAIT_INPUT(false, null, 3),
    TIMEOUT(false, null, 4);

    public static final long MASK = 175L;
    public static final long INSIDE_WAIT = 0x100000000L;
    public static final long WAIT_TIMEOUT = 0x200000000L;
    public final boolean shouldWait;
    public final Integer threadState;
    public final int precedence;

    private DebugStatus(boolean shouldWait, Integer threadState, int precedence) {
        this.shouldWait = shouldWait;
        this.threadState = threadState;
        this.precedence = precedence;
    }

    public static DebugStatus fromArgument(long argument) {
        return DebugStatus.values()[(int)(argument & 0xAFL)];
    }

    public static boolean isInsideWait(long argument) {
        return (argument & 0x100000000L) != 0L;
    }

    public static boolean isWaitTimeout(long argument) {
        return (argument & 0x200000000L) != 0L;
    }

    public static DebugStatus update(DebugStatus added) {
        return added;
    }
}

