/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import com.google.common.base.Function;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridCoordinates;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.GridPoint;
import ghidra.graph.viewer.layout.Row;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LayoutLocationMap<V, E> {
    private int numRows;
    private int numColumns;
    private TreeMap<Integer, Row<V>> rowsByIndex = new TreeMap();
    private TreeMap<Integer, Column<V>> columnsByIndex = new TreeMap();
    private boolean isCondensed = false;
    private GridLocationMap<V, E> gridLocations;

    public LayoutLocationMap(GridLocationMap<V, E> gridLocations, Function<V, Shape> transformer, boolean isCondensed, TaskMonitor monitor) throws CancelledException {
        this.isCondensed = isCondensed;
        this.gridLocations = gridLocations;
        Set<V> vertices = gridLocations.vertices();
        this.numRows = gridLocations.height();
        this.numColumns = gridLocations.width();
        this.initializeLayoutLocations(transformer, vertices, monitor);
    }

    public void dispose() {
        this.rowsByIndex.clear();
        this.columnsByIndex.clear();
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public Column<V> col(V v) {
        Integer col = this.gridLocations.col(v);
        return this.doGetColumn(col);
    }

    public Column<V> col(int gridX) {
        return this.doGetColumn(gridX);
    }

    public Column<V> getColumnContaining(int x) {
        Column<V> column = null;
        Collection<Column<V>> values = this.columnsByIndex.values();
        for (Column<V> nextColumn : values) {
            if (x < nextColumn.x) {
                return column;
            }
            column = nextColumn;
        }
        return column;
    }

    private Column<V> doGetColumn(int index) {
        Column<V> column = this.columnsByIndex.get(index);
        if (column == null) {
            column = new Column(index);
            this.columnsByIndex.put(index, column);
        }
        return column;
    }

    public Collection<Column<V>> columns() {
        ArrayList<Column<V>> result = new ArrayList<Column<V>>();
        Collection<Column<V>> values = this.columnsByIndex.values();
        for (Column<V> column : values) {
            result.add(column);
        }
        return result;
    }

    public Collection<Row<V>> rows() {
        ArrayList<Row<V>> results = new ArrayList<Row<V>>();
        Collection<Row<V>> values = this.rowsByIndex.values();
        for (Row<V> row : values) {
            results.add(row);
        }
        return results;
    }

    public Column<V> lastColumn() {
        Map.Entry<Integer, Column<V>> lastEntry = this.columnsByIndex.lastEntry();
        if (lastEntry == null) {
            return null;
        }
        return lastEntry.getValue();
    }

    public Column<V> nextColumn(Column<V> column) {
        Column<V> nextColumn = this.doGetColumn(column.index + 1);
        if (!nextColumn.isInitialized()) {
            nextColumn.x = column.x + column.getPaddedWidth(this.isCondensed);
        }
        return nextColumn;
    }

    public List<GridPoint> articulations(E e) {
        return this.gridLocations.getArticulations(e);
    }

    public Row<V> row(V v) {
        int row = this.gridLocations.row(v);
        return this.doGetRow(row);
    }

    public Row<V> lastRow() {
        Map.Entry<Integer, Row<V>> lastEntry = this.rowsByIndex.lastEntry();
        if (lastEntry == null) {
            return null;
        }
        return lastEntry.getValue();
    }

    public Row<V> row(int gridY) {
        return this.doGetRow(gridY);
    }

    private Row<V> doGetRow(int index) {
        Row<V> row = this.rowsByIndex.get(index);
        if (row == null) {
            row = new Row(index);
            this.rowsByIndex.put(index, row);
        }
        return row;
    }

    public int gridX(Column col) {
        return col.index;
    }

    public int gridY(Row<V> row) {
        return row.index;
    }

    public List<Integer> getRowOffsets() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Row<V> row : this.rowsByIndex.values()) {
            list.add(row.y);
        }
        return list;
    }

    public List<Integer> getColOffsets() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Column<V> column : this.columnsByIndex.values()) {
            list.add(column.x);
        }
        return list;
    }

    public boolean isCondensed() {
        return this.isCondensed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\n\trows=" + String.valueOf(this.rowsByIndex) + "\n\tcolumns=" + String.valueOf(this.columnsByIndex) + "]";
    }

    public GridCoordinates getGridCoordinates() {
        Row<V> lastRow = this.lastRow();
        Column<V> lastColumn = this.lastColumn();
        if (lastRow == null || lastColumn == null) {
            return new GridCoordinates(new int[0], new int[0]);
        }
        int[] rowStarts = new int[lastRow.index + 1];
        int[] colStarts = new int[lastColumn.index + 1];
        for (Row<V> row : this.rowsByIndex.values()) {
            rowStarts[row.index] = row.y;
        }
        for (Column column : this.columnsByIndex.values()) {
            colStarts[column.index] = column.x;
        }
        for (int row = 1; row < rowStarts.length; ++row) {
            if (rowStarts[row] != 0) continue;
            rowStarts[row] = rowStarts[row - 1];
        }
        for (int col = 1; col < colStarts.length; ++col) {
            if (colStarts[col] != 0) continue;
            colStarts[col] = colStarts[col - 1];
        }
        rowStarts[rowStarts.length - 1] = lastRow.y + lastRow.getPaddedHeight(this.isCondensed);
        colStarts[colStarts.length - 1] = lastColumn.x + lastColumn.getPaddedWidth(this.isCondensed);
        return new GridCoordinates(rowStarts, colStarts);
    }

    private void initializeLayoutLocations(Function<V, Shape> transformer, Collection<V> vertices, TaskMonitor monitor) throws CancelledException {
        int i;
        Column<Row<V>> column;
        Collection<Row<V>> gridRows = this.gridLocations.rowsMap().values();
        for (Row<V> row : gridRows) {
            this.rowsByIndex.put(row.index, row);
        }
        for (Row<V> vertex : vertices) {
            monitor.checkCancelled();
            Row<Row<V>> row = this.row(vertex);
            column = this.col(vertex);
            Shape shape = (Shape)transformer.apply(vertex);
            Rectangle bounds = shape.getBounds();
            if (bounds.width > column.width) {
                column.width = bounds.width;
            }
            if (bounds.height <= row.height) continue;
            row.height = bounds.height;
        }
        int offset = 0;
        int n = this.getRowCount();
        for (i = 0; i < n; ++i) {
            monitor.checkCancelled();
            Row<V> row = this.row(i);
            row.y = offset;
            offset += row.getPaddedHeight(this.isCondensed);
        }
        offset = 0;
        n = this.getColumnCount();
        for (i = 0; i < n; ++i) {
            monitor.checkCancelled();
            column = this.col(i);
            column.x = offset;
            offset += column.getPaddedWidth(this.isCondensed);
        }
    }
}

