/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.img3.Img3Constants;
import ghidra.file.formats.ios.img3.Img3FileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;

public class Img3FileSystemFactory
implements GFileSystemFactoryByteProvider<Img3FileSystem>,
GFileSystemProbeBytesOnly {
    public int getBytesRequired() {
        return Img3Constants.IMG3_SIGNATURE_BYTES.length;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return Arrays.equals(startBytes, 0, Img3Constants.IMG3_SIGNATURE_BYTES.length, Img3Constants.IMG3_SIGNATURE_BYTES, 0, Img3Constants.IMG3_SIGNATURE_BYTES.length);
    }

    public Img3FileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        return new Img3FileSystem(targetFSRL, byteProvider, fsService, monitor);
    }
}

