/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CommentStreamA
implements StructConverter {
    public static final String NAME = "MINIDUMP_COMMENT_A";
    private int commentLength;
    private String comment;
    private DumpFileReader reader;
    private long index;

    CommentStreamA(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.comment = this.reader.readNextAsciiString();
        this.commentLength = (int)(this.reader.getPointerIndex() - this.index);
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(ASCII, this.commentLength, "Comment", null);
        return struct;
    }

    public String getCommentA() {
        return this.comment;
    }

    public void setCommentA(String comment) {
        this.comment = comment;
    }
}

