/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cart.CartInvalidARC4KeyException;
import ghidra.file.formats.cart.CartInvalidCartException;
import ghidra.file.formats.cart.CartV1Decryptor;
import java.io.IOException;

public final class CartV1Header {
    private String magic;
    private short version = (short)-1;
    private long reserved = -1L;
    private byte[] arc4Key;
    private long optionalHeaderLength = -1L;
    private JsonObject optionalHeaderData;
    private long readerLength = -1L;
    private BinaryReader internalReader;

    public CartV1Header(ByteProvider byteProvider) throws IOException, CartInvalidCartException {
        this(new BinaryReader(byteProvider, true));
    }

    public CartV1Header(BinaryReader reader) throws IOException, CartInvalidCartException {
        if (!reader.isLittleEndian()) {
            throw new IOException("CaRT BinaryReader must be Little-Endian.");
        }
        this.readerLength = reader.length();
        if (this.readerLength < 38L) {
            throw new CartInvalidCartException("Data too small to contain CaRT header.");
        }
        this.internalReader = reader.clone(0L);
        this.magic = this.internalReader.readNextAsciiString("CART".length());
        if (!this.magic.equals("CART")) {
            throw new CartInvalidCartException("Invalid CaRT header magic value.");
        }
        this.version = this.internalReader.readNextShort();
        if (this.version != 1) {
            throw new CartInvalidCartException("Invalid CaRT header version number.");
        }
        this.reserved = this.internalReader.readNextLong();
        if (this.reserved != 0L) {
            throw new CartInvalidCartException("Invalid CaRT header reserved value.");
        }
        this.arc4Key = this.internalReader.readNextByteArray(16);
        this.optionalHeaderLength = this.internalReader.readNextLong();
        if (this.optionalHeaderLength < 0L || this.optionalHeaderLength > this.readerLength - 38L - 28L) {
            throw new CartInvalidCartException("Invalid CaRT optional header length.");
        }
    }

    protected String magic() {
        return this.magic;
    }

    protected short version() {
        return this.version;
    }

    protected byte[] arc4Key() throws CartInvalidCartException {
        byte[] arc4KeyCopy = new byte[16];
        if (this.arc4Key == null) {
            throw new CartInvalidCartException("No ARC4 key available for CaRT.");
        }
        System.arraycopy(this.arc4Key, 0, arc4KeyCopy, 0, 16);
        return arc4KeyCopy;
    }

    protected long dataStart() {
        return 38L + this.optionalHeaderLength;
    }

    protected long optionalHeaderLength() {
        return this.optionalHeaderLength;
    }

    protected JsonObject optionalHeaderData() {
        JsonObject optionalHeaderDataCopy = this.optionalHeaderData != null ? this.optionalHeaderData.deepCopy() : null;
        return optionalHeaderDataCopy;
    }

    public JsonObject loadOptionalHeader(CartV1Decryptor decryptor) throws CartInvalidARC4KeyException, IOException {
        byte[] encryptedOptionalHeader = null;
        if (this.optionalHeaderLength > 0L && this.optionalHeaderLength <= this.readerLength - 38L - 28L) {
            try {
                encryptedOptionalHeader = this.internalReader.readByteArray(38L, (int)this.optionalHeaderLength);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (encryptedOptionalHeader == null) {
            this.optionalHeaderData = new JsonObject();
        } else {
            String decryptedOptionalHeader = decryptor.decryptToString(encryptedOptionalHeader);
            if (decryptedOptionalHeader != null) {
                try {
                    this.optionalHeaderData = JsonParser.parseString((String)decryptedOptionalHeader).getAsJsonObject();
                }
                catch (JsonSyntaxException | IllegalStateException e) {
                    throw new CartInvalidARC4KeyException("CaRT decrypted optional header not valid JSON.");
                }
                if (this.optionalHeaderData == null) {
                    this.optionalHeaderData = new JsonObject();
                }
            } else {
                throw new CartInvalidARC4KeyException("CaRT optional header decryption failed.");
            }
        }
        return this.optionalHeaderData();
    }
}

