/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.vdex.UnsupportedVdexVersionException;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.file.formats.android.vdex.VdexStringTable;
import ghidra.file.formats.android.vdex.sections.DexSectionHeader_002;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VdexHeader_019
extends VdexHeader {
    private String verifier_deps_version_;
    private String dex_section_version_;
    private int number_of_dex_files_;
    private int verifier_deps_size_;
    private int[] dex_checksums_;
    private DexSectionHeader_002 sectionHeader;
    private List<Integer> quickenTableOffsetList = new ArrayList<Integer>();

    public VdexHeader_019(BinaryReader reader) throws IOException, UnsupportedVdexVersionException {
        super(reader);
        int i;
        this.verifier_deps_version_ = reader.readNextAsciiString(4);
        this.dex_section_version_ = reader.readNextAsciiString(4);
        this.number_of_dex_files_ = reader.readNextInt();
        this.verifier_deps_size_ = reader.readNextInt();
        this.dex_checksums_ = new int[this.number_of_dex_files_];
        for (i = 0; i < this.number_of_dex_files_; ++i) {
            this.dex_checksums_[i] = reader.readNextInt();
        }
        if ("002".equals(this.dex_section_version_)) {
            this.sectionHeader = new DexSectionHeader_002(reader);
            for (i = 0; i < this.number_of_dex_files_; ++i) {
                this.quickenTableOffsetList.add(reader.readNextInt());
                long index = reader.getPointerIndex();
                this.dexHeaderStartsList.add(index);
                ByteProviderWrapper wrapperProvider = new ByteProviderWrapper(reader.getByteProvider(), index, reader.getByteProvider().length() - index);
                BinaryReader wrappedReader = new BinaryReader((ByteProvider)wrapperProvider, reader.isLittleEndian());
                DexHeader cdexHeader = DexHeaderFactory.getDexHeader(wrappedReader);
                this.dexHeaderList.add(cdexHeader);
                reader.setPointerIndex(index + (long)cdexHeader.getFileSize());
            }
        } else if ("000".equals(this.dex_section_version_)) {
            this.stringTable = new VdexStringTable(reader);
        } else {
            throw new UnsupportedVdexVersionException("Unknown VDEX section version: " + this.dex_section_version_);
        }
    }

    @Override
    public String getVersion() {
        return this.verifier_deps_version_;
    }

    @Override
    public void parse(BinaryReader reader, TaskMonitor monitor) throws IOException, CancelledException {
    }

    public String getDexSectionVersion() {
        return this.dex_section_version_;
    }

    public int getNumberOfDexFiles() {
        return this.number_of_dex_files_;
    }

    @Override
    public int getVerifierDepsSize() {
        return this.verifier_deps_size_;
    }

    @Override
    public int getQuickeningInfoSize() {
        return 0;
    }

    @Override
    public DexSectionHeader_002 getDexSectionHeader_002() {
        return this.sectionHeader;
    }

    @Override
    public int[] getDexChecksums() {
        return this.dex_checksums_;
    }

    @Override
    public boolean isDexHeaderEmbeddedInDataType() {
        return false;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        structure.add(STRING, 4, "verifier_deps_version_", null);
        structure.add(STRING, 4, "dex_section_version_", null);
        structure.add(DWORD, "number_of_dex_files_", null);
        structure.add(DWORD, "verifier_deps_size_", null);
        for (int i = 0; i < this.dex_checksums_.length; ++i) {
            structure.add(DWORD, "dex_checksum_" + i, null);
        }
        if (this.sectionHeader != null) {
            structure.add(this.sectionHeader.toDataType(), "dex_section_header_", null);
        }
        if (this.stringTable != null) {
            structure.add(this.stringTable.toDataType(), "strings", null);
        }
        return structure;
    }
}

