/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.quickmethod;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader_Lollipop;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader_LollipopMR1;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader_Nougat;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader_Oreo;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader_Q_R;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader_S_T;
import java.io.IOException;

public final class OatQuickMethodHeaderFactory {
    public static final int getOatQuickMethodHeaderSize(String oatVersion) throws IOException {
        switch (oatVersion) {
            case "039": {
                return 24;
            }
            case "045": 
            case "051": 
            case "064": {
                return 28;
            }
            case "079": 
            case "088": {
                return 20;
            }
            case "124": 
            case "131": 
            case "126": 
            case "138": {
                return 24;
            }
            case "170": 
            case "183": {
                return 8;
            }
            case "195": 
            case "199": 
            case "220": 
            case "223": 
            case "225": {
                return 4;
            }
        }
        throw new IOException("OatQuickMethodHeader unsupported OAT version: " + oatVersion);
    }

    public static final OatQuickMethodHeader getOatQuickMethodHeader(BinaryReader reader, String oatVersion) throws IOException {
        switch (oatVersion) {
            case "039": {
                return new OatQuickMethodHeader_Lollipop(reader);
            }
            case "045": 
            case "051": 
            case "064": {
                return new OatQuickMethodHeader_LollipopMR1(reader);
            }
            case "079": 
            case "088": {
                return new OatQuickMethodHeader_Nougat(reader);
            }
            case "124": 
            case "131": 
            case "126": 
            case "138": {
                return new OatQuickMethodHeader_Oreo(reader);
            }
            case "170": 
            case "183": {
                return new OatQuickMethodHeader_Q_R(reader);
            }
            case "195": 
            case "199": 
            case "220": 
            case "223": 
            case "225": {
                return new OatQuickMethodHeader_S_T(reader);
            }
        }
        throw new IOException("OatQuickMethodHeader unsupported OAT version: " + oatVersion);
    }
}

