/*
 * Decompiled with CFR 0.152.
 */
package utility.module;

import generic.jar.ResourceFile;
import ghidra.framework.GModule;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import utility.module.ModuleUtilities;

public class ClasspathFilter
implements Predicate<GModule> {
    private Predicate<Path> additionalPaths = p -> false;
    private Set<Path> cpModulePaths = new HashSet<Path>();

    public ClasspathFilter() {
        String[] cpPathStrings;
        String cp = System.getProperty("java.class.path");
        for (String cpPathString : cpPathStrings = cp.split(File.pathSeparator)) {
            Path modulePath = ModuleUtilities.getModule(cpPathString);
            if (modulePath == null) continue;
            Path normalized = modulePath.normalize().toAbsolutePath();
            this.cpModulePaths.add(normalized);
        }
    }

    public ClasspathFilter(Predicate<Path> additionalPaths) {
        this();
        this.additionalPaths = additionalPaths;
    }

    @Override
    public boolean test(GModule m) {
        ResourceFile file = m.getModuleRoot();
        Path path = Path.of(file.getAbsolutePath(), new String[0]);
        Path normalized = path.normalize().toAbsolutePath();
        return this.additionalPaths.test(normalized) || this.cpModulePaths.contains(normalized);
    }
}

