/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.store.FileSystem;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public abstract class GhidraProtocolConnector {
    protected final URL url;
    protected String repositoryName;
    protected final String itemPath;
    protected String folderPath;
    protected String folderItemName = null;
    protected GhidraURLConnection.StatusCode statusCode = null;
    protected RepositoryAdapter repositoryAdapter;
    protected RepositoryServerAdapter repositoryServerAdapter;

    protected GhidraProtocolConnector(URL url) throws MalformedURLException {
        this.url = url;
        this.checkProtocol();
        this.checkUserInfo();
        this.checkHostInfo();
        this.repositoryName = this.parseRepositoryName();
        this.itemPath = this.parseItemPath();
    }

    protected abstract URL getRepositoryRootGhidraURL();

    protected void checkProtocol() throws MalformedURLException {
        if (!"ghidra".equals(this.url.getProtocol())) {
            throw new MalformedURLException("expected ghidra URL protocol");
        }
    }

    protected void checkUserInfo() throws MalformedURLException {
        if (this.url.getUserInfo() != null) {
            throw new MalformedURLException("URL does not support user info");
        }
    }

    protected void checkHostInfo() throws MalformedURLException {
        String host = this.url.getHost();
        if (host.length() == 0) {
            throw new MalformedURLException("missing server host specification");
        }
    }

    private String parseRepositoryName() throws MalformedURLException {
        String path = this.url.getPath();
        if (StringUtils.isBlank((CharSequence)path) || path.length() < 2 || path.charAt(0) != '/') {
            return null;
        }
        int index = (path = path.substring(1)).indexOf(FileSystem.SEPARATOR);
        if (index >= 0) {
            path = path.substring(0, index);
        }
        if (path.length() == 0) {
            throw new MalformedURLException("invalid path specification");
        }
        return path;
    }

    protected final String initFolderItemPath(String contentPath) throws MalformedURLException {
        if (StringUtils.isBlank((CharSequence)contentPath)) {
            this.folderPath = FileSystem.SEPARATOR;
            return this.folderPath;
        }
        if (!contentPath.startsWith(FileSystem.SEPARATOR)) {
            throw new MalformedURLException("invalid content path specification");
        }
        boolean isFolder = contentPath.endsWith(FileSystem.SEPARATOR);
        this.folderPath = "";
        String pathToSplit = isFolder ? contentPath.substring(0, contentPath.length() - 1) : contentPath;
        String[] pieces = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)pathToSplit, (String)FileSystem.SEPARATOR);
        if (pieces.length == 0) {
            this.folderPath = FileSystem.SEPARATOR;
            return this.folderPath;
        }
        for (int i = 1; i < pieces.length; ++i) {
            String p = pieces[i];
            if (p.length() == 0) {
                throw new MalformedURLException("invalid content path specification");
            }
            if (!isFolder && i == pieces.length - 1) {
                this.folderItemName = p;
                continue;
            }
            this.folderPath = this.folderPath + FileSystem.SEPARATOR + p;
        }
        if (this.folderPath.length() == 0) {
            this.folderPath = FileSystem.SEPARATOR;
        }
        return contentPath;
    }

    protected String parseItemPath() throws MalformedURLException {
        String path = this.url.getPath();
        if (this.repositoryName == null) {
            if (!StringUtils.isEmpty((CharSequence)path) && !"/".equals(path)) {
                throw new MalformedURLException();
            }
            return null;
        }
        path = path.substring(this.repositoryName.length() + 1);
        path = this.initFolderItemPath(path);
        return path;
    }

    public GhidraURLConnection.StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public RepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    public RepositoryServerAdapter getRepositoryServerAdapter() {
        return this.repositoryServerAdapter;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getFolderItemName() {
        return this.folderItemName;
    }

    private String appendSubfolderName(String folder, String subfolderName) {
        if (!((String)folder).endsWith(FileSystem.SEPARATOR)) {
            folder = (String)folder + FileSystem.SEPARATOR;
        }
        return (String)folder + this.folderItemName;
    }

    protected void resolveItemPath() throws IOException {
        if (this.folderItemName != null) {
            String path;
            if (this.itemPath.endsWith("/")) {
                this.folderPath = this.appendSubfolderName(this.folderPath, this.folderItemName);
                this.folderItemName = null;
            } else if (!this.repositoryAdapter.fileExists(this.folderPath, this.folderItemName) && this.repositoryAdapter.folderExists(path = this.appendSubfolderName(this.folderPath, this.folderItemName))) {
                this.folderPath = path;
                this.folderItemName = null;
            }
        }
    }

    protected void connect(RepositoryAdapter repository) throws IOException {
        if (this.statusCode != null) {
            throw new IllegalStateException("already connected");
        }
        if (this.repositoryName == null || !this.repositoryName.equals(repository.getName())) {
            throw new UnsupportedOperationException("invalid repository connection");
        }
        if (!repository.isConnected()) {
            throw new IllegalStateException("expected connected repository");
        }
        this.statusCode = GhidraURLConnection.StatusCode.OK;
        this.repositoryAdapter = repository;
        this.repositoryServerAdapter = repository.getServer();
        this.resolveItemPath();
    }

    public abstract GhidraURLConnection.StatusCode connect(boolean var1) throws IOException;

    public abstract boolean isReadOnly() throws NotConnectedException;
}

