/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.Objects;
import java.util.Set;

class CountDomainFilesTask
extends Task {
    private Set<DomainFolder> folders;
    private Set<DomainFile> files;
    private int fileCount;
    private boolean cancelled;

    public CountDomainFilesTask(Set<DomainFolder> folders, Set<DomainFile> files) {
        super("Counting Files", true, false, true);
        this.folders = Objects.requireNonNull(folders);
        this.files = Objects.requireNonNull(files);
    }

    public void run(TaskMonitor monitor) {
        this.countFiles(monitor);
    }

    private void countFiles(TaskMonitor monitor) {
        try {
            this.fileCount = this.files.size();
            for (DomainFolder folder : this.folders) {
                monitor.checkCancelled();
                this.countFiles(folder, monitor);
            }
        }
        catch (CancelledException e) {
            this.cancelled = true;
        }
    }

    private void countFiles(DomainFolder folder, TaskMonitor monitor) throws CancelledException {
        for (DomainFile domainFile : folder.getFiles()) {
            if (this.files.contains(domainFile)) continue;
            ++this.fileCount;
        }
        for (Comparable<DomainFile> comparable : folder.getFolders()) {
            monitor.checkCancelled();
            if (this.folders.contains(comparable)) continue;
            this.countFiles((DomainFolder)comparable, monitor);
        }
    }

    boolean wasCancelled() {
        return this.cancelled;
    }

    int getFileCount() {
        return this.fileCount;
    }
}

