/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.SpannedRenderer;
import generic.Span;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import java.awt.Graphics;

public class SpanSetTableCellRenderer<N extends Number>
extends AbstractGColumnRenderer<Span.SpanSet<N, ?>>
implements SpannedRenderer<N> {
    protected SpannedRenderer.DoubleSpan fullRangeDouble = new SpannedRenderer.DoubleSpan(0.0, 1.0);
    protected double span = 1.0;
    protected Span<N, ?> fullRange;
    protected Span.SpanSet<N, ?> dataRangeSet;

    @Override
    public void setFullRange(Span<N, ?> fullRange) {
        this.fullRange = fullRange;
        this.fullRangeDouble = SpannedRenderer.validateViewRange(fullRange);
        this.span = this.fullRangeDouble.max() - this.fullRangeDouble.min();
    }

    public String getFilterString(Span.SpanSet<N, ?> t, Settings settings) {
        return "";
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        this.dataRangeSet = (Span.SpanSet)data.getValue();
        super.getTableCellRendererComponent(data);
        this.setText("");
        return this;
    }

    protected void paintComponent(Graphics parentG) {
        super.paintComponent(parentG);
        if (this.dataRangeSet == null || this.dataRangeSet.isEmpty()) {
            return;
        }
        Graphics g = parentG.create();
        g.setColor(this.getForeground());
        for (Span span : this.dataRangeSet.spans()) {
            this.paintRange(g, span);
        }
    }

    @Override
    public Span<N, ?> getFullRange() {
        return this.fullRange;
    }

    public SpannedRenderer.DoubleSpan getFullRangeDouble() {
        return this.fullRangeDouble;
    }

    @Override
    public double getSpan() {
        return this.span;
    }
}

