/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.ApplicationThemeManager;
import generic.theme.GThemeValueMap;
import generic.theme.laf.NimbusUiDefaultsMapper;
import generic.theme.laf.UiDefaultsMapper;
import generic.theme.laf.nimbus.SelectedTreePainter;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public class CustomNimbusLookAndFeel
extends NimbusLookAndFeel {
    private ApplicationThemeManager themeManager;
    private Map<String, String> normalizedIdToLafIdMap;

    CustomNimbusLookAndFeel(ApplicationThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        this.installCustomPainters(defaults);
        NimbusUiDefaultsMapper uiDefaultsMapper = new NimbusUiDefaultsMapper(defaults);
        this.installJavaDefaultsIntoThemeManager(uiDefaultsMapper);
        uiDefaultsMapper.installValuesIntoUIDefaults(this.themeManager.getCurrentValues());
        this.normalizedIdToLafIdMap = uiDefaultsMapper.getNormalizedIdToLafIdMap();
        return defaults;
    }

    protected void installJavaDefaultsIntoThemeManager(UiDefaultsMapper uiDefaultsMapper) {
        GThemeValueMap javaDefaults = uiDefaultsMapper.getNormalizedJavaDefaults();
        this.themeManager.setJavaDefaults(javaDefaults);
    }

    private void installCustomPainters(UIDefaults defaults) {
        defaults.put("Tree:TreeCell[Enabled+Selected].backgroundPainter", new SelectedTreePainter());
        defaults.put("Tree:TreeCell[Focused+Selected].backgroundPainter", new SelectedTreePainter());
    }

    public Map<String, String> getNormalizedIdToLafIdMap() {
        return this.normalizedIdToLafIdMap;
    }
}

