/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class ThemeValueUtils {
    public static List<String> parseGroupings(String source, char startChar, char endChar) throws ParseException {
        int groupStart;
        ArrayList<String> results = new ArrayList<String>();
        int index = 0;
        while (index < source.length() && (groupStart = ThemeValueUtils.findNextNonWhiteSpaceChar(source, index)) >= 0) {
            if (source.charAt(groupStart) != startChar) {
                throw new ParseException("Error parsing groupings for " + source, index);
            }
            int groupEnd = ThemeValueUtils.findMatchingEnd(source, groupStart + 1, startChar, endChar);
            if (groupEnd < 0) {
                throw new ParseException("Error parsing groupings for " + source, index);
            }
            results.add(source.substring(groupStart + 1, groupEnd));
            index = groupEnd + 1;
        }
        return results;
    }

    private static int findMatchingEnd(String source, int index, char startChar, char endChar) {
        int level = 0;
        while (index < source.length()) {
            char c = source.charAt(index);
            if (c == startChar) {
                ++level;
            } else if (c == endChar) {
                if (level == 0) {
                    return index;
                }
                --level;
            }
            ++index;
        }
        return -1;
    }

    private static int findNextNonWhiteSpaceChar(String source, int index) {
        while (index < source.length()) {
            if (!Character.isWhitespace(source.charAt(index))) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

