/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.JavaPropertyValue;
import ghidra.util.Msg;

public class StringPropertyValue
extends JavaPropertyValue {
    private static final String EXTERNAL_LAF_ID_PREFIX = "[laf.string]";

    public StringPropertyValue(String id, String value) {
        this(id, (String)null, value);
    }

    public StringPropertyValue(String id, String refId, String value) {
        super(id, refId, value);
    }

    public static boolean isStringKey(String key) {
        return key.toLowerCase().startsWith(EXTERNAL_LAF_ID_PREFIX);
    }

    public static StringPropertyValue parse(String key, String value) {
        String id = StringPropertyValue.fromExternalId(key);
        if (StringPropertyValue.isStringKey(value)) {
            String refId = StringPropertyValue.fromExternalId(value);
            return new StringPropertyValue(id, refId, null);
        }
        return new StringPropertyValue(id, value);
    }

    private static String fromExternalId(String externalId) {
        if (!externalId.toLowerCase().startsWith(EXTERNAL_LAF_ID_PREFIX)) {
            return externalId;
        }
        return externalId.substring(EXTERNAL_LAF_ID_PREFIX.length());
    }

    @Override
    protected Object getUnresolvedReferenceValue(String primaryId, String unresolvedId) {
        Msg.warn((Object)this, (Object)("Could not resolve indirect property for \"" + unresolvedId + "\" for primary id \"" + primaryId + "\", using last resort default"));
        return "";
    }

    @Override
    protected String toExternalId(String internalId) {
        return EXTERNAL_LAF_ID_PREFIX + internalId;
    }

    @Override
    protected String getSerializedValue() {
        return String.valueOf(this.value);
    }
}

