/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.GIcon;
import generic.theme.GThemeValueMap;
import generic.theme.IconModifier;
import generic.theme.ThemeManager;
import generic.theme.ThemeValue;
import ghidra.util.Msg;
import java.text.ParseException;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import resources.ResourceManager;
import resources.icons.EmptyIcon;
import resources.icons.UrlImageIcon;

public class IconValue
extends ThemeValue<Icon> {
    private static final String EMPTY_ICON_STRING = "EMPTY_ICON";
    public static final String LAF_ID_PREFIX = "laf.icon.";
    public static final String EXTERNAL_LAF_ID_PREFIX = "[laf.icon]";
    static final String ICON_ID_PREFIX = "icon.";
    private static final String EXTERNAL_PREFIX = "[icon]";
    public static final Icon LAST_RESORT_DEFAULT = ResourceManager.getDefaultIcon();
    private static final int STANDARD_EMPTY_ICON_SIZE = 16;
    private IconModifier modifier;

    public IconValue(String id, Icon icon) {
        super(id, IconValue.getRefId(icon), IconValue.getRawIcon(icon));
    }

    public IconValue(String id, String refId) {
        super(id, refId, null);
    }

    private IconValue(String id, String refId, IconModifier modifier) {
        super(id, refId, null);
        this.modifier = modifier;
    }

    private IconValue(String id, Icon icon, IconModifier modifier) {
        super(id, null, icon);
        this.modifier = modifier;
    }

    @Override
    public String getSerializationString() {
        String outputId = IconValue.toExternalId(this.id);
        return outputId + " = " + this.getValueOutput();
    }

    @Override
    public boolean isExternal() {
        return !this.id.startsWith(ICON_ID_PREFIX);
    }

    @Override
    public Icon get(GThemeValueMap values) {
        Icon icon = (Icon)super.get(values);
        if (this.modifier != null) {
            return this.modifier.modify(icon, values);
        }
        return icon;
    }

    public static boolean isIconKey(String key) {
        return StringUtils.startsWithAny((CharSequence)key, (CharSequence[])new CharSequence[]{ICON_ID_PREFIX, EXTERNAL_PREFIX, EXTERNAL_LAF_ID_PREFIX});
    }

    public static String iconToString(Icon icon) {
        if (icon instanceof EmptyIcon) {
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            if (iconWidth == 16 && iconHeight == 16) {
                return EMPTY_ICON_STRING;
            }
            return "EMPTY_ICON[size(" + iconWidth + "," + iconHeight + ")]";
        }
        if (icon instanceof UrlImageIcon) {
            UrlImageIcon urlIcon = (UrlImageIcon)icon;
            return urlIcon.getOriginalPath();
        }
        return "<JAVA ICON>";
    }

    public static IconValue parse(String key, String value) throws ParseException {
        String id = IconValue.fromExternalId(key);
        if (IconValue.isIconKey(value)) {
            return IconValue.parseRefIcon(id, value);
        }
        return IconValue.parseIcon(id, value);
    }

    private static IconValue parseIcon(String id, String value) throws ParseException {
        int modifierIndex = IconValue.getModifierIndex(value);
        if (modifierIndex < 0) {
            if (value.isBlank()) {
                return null;
            }
            return new IconValue(id, IconValue.getIcon(value));
        }
        String baseIconString = value.substring(0, modifierIndex).trim();
        if (baseIconString.isBlank()) {
            return null;
        }
        Icon icon = IconValue.getIcon(baseIconString);
        String iconModifierString = value.substring(modifierIndex);
        IconModifier modifier = IconModifier.parse(iconModifierString);
        return new IconValue(id, icon, modifier);
    }

    private static Icon getIcon(String baseIconString) throws ParseException {
        if (EMPTY_ICON_STRING.equals(baseIconString)) {
            return new EmptyIcon(16, 16);
        }
        Icon icon = ResourceManager.loadIcon(baseIconString);
        if (icon == null) {
            throw new ParseException("Can't find icon for \"" + baseIconString + "\"", 0);
        }
        return icon;
    }

    private static IconValue parseRefIcon(String id, String value) throws ParseException {
        int modifierIndex = IconValue.getModifierIndex(value = IconValue.fromExternalId(value));
        if (modifierIndex < 0) {
            return new IconValue(id, value);
        }
        String refId = value.substring(0, modifierIndex).trim();
        IconModifier modifier = IconModifier.parse(value.substring(modifierIndex));
        return new IconValue(id, refId, modifier);
    }

    private static int getModifierIndex(String value) {
        int baseModifierIndex = value.indexOf("[", 1);
        int overlayModifierIndex = value.indexOf("{");
        if (baseModifierIndex < 0) {
            return overlayModifierIndex;
        }
        if (overlayModifierIndex < 0) {
            return baseModifierIndex;
        }
        return Math.min(overlayModifierIndex, baseModifierIndex);
    }

    protected IconValue getReferredValue(GThemeValueMap values, String refId) {
        return values.getIcon(refId);
    }

    @Override
    protected Icon getUnresolvedReferenceValue(String primaryId, String unresolvedId) {
        Msg.warn((Object)this, (Object)("Could not resolve indirect icon path for \"" + unresolvedId + "\" for primary id \"" + primaryId + "\", using last resort default"));
        return LAST_RESORT_DEFAULT;
    }

    private static String toExternalId(String internalId) {
        if (internalId.startsWith(ICON_ID_PREFIX)) {
            return internalId;
        }
        if (internalId.startsWith(LAF_ID_PREFIX)) {
            String baseId = internalId.substring(LAF_ID_PREFIX.length());
            return EXTERNAL_LAF_ID_PREFIX + baseId;
        }
        return EXTERNAL_PREFIX + internalId;
    }

    private static String fromExternalId(String externalId) {
        if (externalId.startsWith(EXTERNAL_PREFIX)) {
            return externalId.substring(EXTERNAL_PREFIX.length());
        }
        if (externalId.startsWith(EXTERNAL_LAF_ID_PREFIX)) {
            return LAF_ID_PREFIX + externalId.substring(EXTERNAL_LAF_ID_PREFIX.length());
        }
        return externalId;
    }

    private static Icon getRawIcon(Icon value) {
        if (value instanceof GIcon) {
            return null;
        }
        return value;
    }

    private static String getRefId(Icon value) {
        if (value instanceof GIcon) {
            return ((GIcon)value).getId();
        }
        return null;
    }

    private String getValueOutput() {
        Object outputString = null;
        outputString = this.referenceId != null ? IconValue.toExternalId(this.referenceId) : IconValue.iconToString((Icon)this.value);
        if (this.modifier != null) {
            outputString = (String)outputString + this.modifier.getSerializationString();
        }
        return outputString;
    }

    @Override
    public void installValue(ThemeManager themeManager) {
        themeManager.setIcon(this);
    }
}

