/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.debug.api.modules.MapEntry;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import java.util.Objects;

public abstract class AbstractMapEntry<T, P>
implements MapEntry<T, P> {
    protected final Trace fromTrace;
    protected final T fromObject;
    protected final long snap;
    protected Program toProgram;
    protected P toObject;

    public AbstractMapEntry(Trace fromTrace, T fromObject, long snap, Program toProgram, P toObject) {
        this.fromTrace = fromTrace;
        this.fromObject = fromObject;
        this.snap = snap;
        this.toProgram = toProgram;
        this.toObject = toObject;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractMapEntry)) {
            return false;
        }
        AbstractMapEntry that = (AbstractMapEntry)obj;
        return this.fromObject == that.fromObject;
    }

    public int hashCode() {
        return Objects.hash(this.fromObject);
    }

    public Trace getFromTrace() {
        return this.fromTrace;
    }

    public T getFromObject() {
        return this.fromObject;
    }

    public Lifespan getFromLifespan() {
        return Lifespan.nowOn((long)this.snap);
    }

    public TraceLocation getFromTraceLocation() {
        return new DefaultTraceLocation(this.fromTrace, null, this.getFromLifespan(), this.getFromRange().getMinAddress());
    }

    protected void setToObject(Program toProgram, P toObject) {
        this.toProgram = toProgram;
        this.toObject = toObject;
    }

    public Program getToProgram() {
        return this.toProgram;
    }

    public P getToObject() {
        return this.toObject;
    }

    public ProgramLocation getToProgramLocation() {
        return new ProgramLocation(this.toProgram, this.getToRange().getMinAddress());
    }

    public long getMappingLength() {
        return Math.min(this.getFromRange().getLength(), this.getToRange().getLength());
    }
}

