/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableFilter;
import ghidra.app.plugin.core.debug.gui.model.AbstractObjectsTableBasedPanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.AbstractTraceValueObjectAddressColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.AbstractTraceValueObjectLengthColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.thread.TraceObjectProcess;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.event.ListSelectionEvent;

public class DebuggerSectionsPanel
extends AbstractObjectsTableBasedPanel<TraceObjectSection> {
    private final DebuggerModulesProvider provider;
    private Set<Object> selectedModuleObjects = Set.of();
    private final SectionsBySelectedModulesTableFilter filterSectionsBySelectedModules = new SectionsBySelectedModulesTableFilter();

    private static TraceObject getModule(ObjectTableModel.ValueRow row) {
        TraceObjectValue moduleEntry = row.getAttributeEntry("_module");
        if (moduleEntry != null && moduleEntry.isObject()) {
            return moduleEntry.getChild();
        }
        return row.getValue().getChild().findCanonicalAncestorsInterface(TraceObjectModule.class).findFirst().orElse(null);
    }

    protected static ModelQuery successorSections(TraceObjectSchema rootSchema, KeyPath path) {
        TraceObjectSchema schema = rootSchema.getSuccessorSchema(path);
        return new ModelQuery(schema.searchFor(TraceObjectSection.class, path, true));
    }

    public DebuggerSectionsPanel(DebuggerModulesProvider provider) {
        super(provider.plugin, (ComponentProvider)provider, TraceObjectSection.class);
        this.provider = provider;
    }

    @Override
    protected ObjectTableModel createModel() {
        return new SectionTableModel(this.plugin);
    }

    @Override
    protected ModelQuery computeQuery(TraceObject object) {
        ModelQuery result;
        ModelQuery result2;
        KeyPath seedPath;
        TraceObjectSchema rootSchema = object.getRoot().getSchema();
        KeyPath processPath = rootSchema.searchForAncestor(TraceObjectProcess.class, seedPath = object.getCanonicalPath());
        if (processPath != null && !(result2 = DebuggerSectionsPanel.successorSections(rootSchema, processPath)).isEmpty()) {
            return result2;
        }
        KeyPath containerPath = rootSchema.searchForSuitableContainer(TraceObjectModule.class, seedPath);
        if (containerPath != null && !(result = DebuggerSectionsPanel.successorSections(rootSchema, containerPath)).isEmpty()) {
            return result;
        }
        return DebuggerSectionsPanel.successorSections(rootSchema, KeyPath.ROOT);
    }

    public void setFilteredBySelectedModules(boolean filtered) {
        if (filtered) {
            this.refreshSelectedModuleObjects();
        }
        this.filterPanel.setSecondaryFilter((TableFilter)(filtered ? this.filterSectionsBySelectedModules : null));
    }

    public void setSelectedSections(Set<TraceSection> sel) {
        this.setSelected(sel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.provider.sectionsPanelContextChanged();
    }

    private void refreshSelectedModuleObjects() {
        this.selectedModuleObjects = this.provider.modulesPanel.getSelectedItems().stream().map(r -> r.getValue().getValue()).collect(Collectors.toSet());
    }

    @Override
    public void reload() {
        this.refreshSelectedModuleObjects();
        super.reload();
    }

    private class SectionsBySelectedModulesTableFilter
    implements TableFilter<ObjectTableModel.ValueRow> {
        private SectionsBySelectedModulesTableFilter() {
        }

        public boolean acceptsRow(ObjectTableModel.ValueRow rowObject) {
            if (DebuggerSectionsPanel.this.selectedModuleObjects.isEmpty()) {
                return true;
            }
            TraceObject module = DebuggerSectionsPanel.getModule(rowObject);
            return DebuggerSectionsPanel.this.selectedModuleObjects.contains(module);
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            return false;
        }
    }

    private class SectionTableModel
    extends ObjectTableModel {
        protected SectionTableModel(Plugin plugin) {
            super(plugin);
        }

        @Override
        protected TableColumnDescriptor<ObjectTableModel.ValueRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addHiddenColumn((DynamicTableColumn)new SectionPathColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new SectionStartColumn(), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new SectionEndColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new SectionNameColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new SectionModuleNameColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new SectionLengthColumn());
            return descriptor;
        }
    }

    private static class SectionLengthColumn
    extends AbstractTraceValueObjectLengthColumn {
        public SectionLengthColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "Length";
        }
    }

    private static class SectionModuleNameColumn
    extends TraceValueObjectPropertyColumn<String> {
        public SectionModuleNameColumn() {
            super(String.class);
        }

        public String getColumnName() {
            return "Module Name";
        }

        @Override
        public ObjectTableModel.ValueProperty<String> getProperty(ObjectTableModel.ValueRow row) {
            return new ObjectTableModel.ValueDerivedProperty<String>(this, row, String.class){

                @Override
                public String getValue() {
                    TraceObject module = DebuggerSectionsPanel.getModule(this.row);
                    if (module == null) {
                        return "";
                    }
                    TraceObjectValue nameEntry = module.getAttribute(this.row.currentSnap(), "_module_name");
                    if (nameEntry == null) {
                        return "";
                    }
                    return nameEntry.getValue().toString();
                }
            };
        }
    }

    private static class SectionPathColumn
    extends TraceValueKeyColumn {
        private SectionPathColumn() {
        }

        @Override
        public String getColumnName() {
            return "Path";
        }

        @Override
        public String getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getValue().getCanonicalPath().toString();
        }
    }

    private static class SectionNameColumn
    extends TraceValueKeyColumn {
        private SectionNameColumn() {
        }

        @Override
        public String getColumnName() {
            return "Name";
        }

        @Override
        public String getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return KeyPath.parseIfIndex((String)rowObject.getValue().getEntryKey());
        }
    }

    private static class SectionEndColumn
    extends AbstractTraceValueObjectAddressColumn {
        public SectionEndColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "End";
        }

        @Override
        protected Address fromRange(AddressRange range) {
            return range.getMaxAddress();
        }
    }

    private static class SectionStartColumn
    extends AbstractTraceValueObjectAddressColumn {
        public SectionStartColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "Start";
        }

        @Override
        protected Address fromRange(AddressRange range) {
            return range.getMinAddress();
        }
    }
}

