/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.Settings;

public class FunctionInlineSettingsDefinition
implements BooleanSettingsDefinition {
    public static final FunctionInlineSettingsDefinition DEF = new FunctionInlineSettingsDefinition();
    private static final String INLINE = "Show inline";
    private static final String NAME = "Show inline";
    private static final String DESCRIPTION = "On signals to show the inline function attribute when present";
    private static final boolean DEFAULT = false;

    public boolean getValue(Settings settings) {
        if (settings == null) {
            return false;
        }
        String value = settings.getString("Show inline");
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public String getValueString(Settings settings) {
        return Boolean.toString(this.getValue(settings));
    }

    public void setValue(Settings settings, boolean value) {
        settings.setString("Show inline", Boolean.toString(value));
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        String value = srcSettings.getString("Show inline");
        if (value == null) {
            destSettings.clearSetting("Show inline");
        } else {
            destSettings.setString("Show inline", value);
        }
    }

    public void clear(Settings settings) {
        settings.clearSetting("Show inline");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return "Show inline";
    }

    public String getStorageKey() {
        return "Show inline";
    }

    public boolean hasValue(Settings settings) {
        return settings.getValue("Show inline") != null;
    }
}

