/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.MappedTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.ProgramTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.CodeUnitTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.table.field.ProgramLocationTableColumn;
import ghidra.util.task.TaskMonitor;

public abstract class GhidraProgramTableModel<ROW_TYPE>
extends ThreadedTableModel<ROW_TYPE, Program>
implements ProgramTableModel {
    protected Program program;

    protected GhidraProgramTableModel(String modelName, ServiceProvider serviceProvider, Program program, TaskMonitor monitor) {
        this(modelName, serviceProvider, program, monitor, false);
    }

    protected GhidraProgramTableModel(String modelName, ServiceProvider serviceProvider, Program program, TaskMonitor monitor, boolean loadIncrementally) {
        super(modelName, serviceProvider, monitor, loadIncrementally);
        this.program = program;
    }

    protected TableColumnDescriptor<ROW_TYPE> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new CodeUnitTableColumn()));
        return descriptor;
    }

    public void setProgram(Program program) {
        Program originalProgram = this.program;
        this.program = program;
        if (originalProgram != program) {
            this.clearData();
        }
    }

    protected Program getProgramForRow(ROW_TYPE t) {
        return this.getProgram();
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public Program getDataSource() {
        return this.getProgram();
    }

    public void dispose() {
        this.program = null;
        super.dispose();
    }

    public Address getAddress(int modelRow, int modelColumn) {
        Object columnValue;
        Object rowObject = this.filteredData.get(modelRow);
        DynamicTableColumn tableColumn = this.getColumn(modelColumn);
        if (tableColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programLocationColumn = (ProgramLocationTableColumn)tableColumn;
            Settings settings = this.getColumnSettings(modelColumn);
            Object value = programLocationColumn.getValue(rowObject, settings, this.getProgram(), this.serviceProvider);
            if (value instanceof Address) {
                return (Address)value;
            }
            if (value instanceof ProgramLocation) {
                ProgramLocation programLocation = (ProgramLocation)value;
                return programLocation.getByteAddress();
            }
            ProgramLocation location = programLocationColumn.getProgramLocation(rowObject, settings, this.getProgram(), this.serviceProvider);
            if (location != null) {
                return location.getByteAddress();
            }
        }
        if ((columnValue = this.getColumnValueForRow(rowObject, modelColumn)) instanceof Address) {
            return (Address)columnValue;
        }
        Address address = this.getAddress(modelRow);
        if (address != null) {
            return address;
        }
        Object mappedRowObject = this.getMappedRowObject(tableColumn, rowObject, modelColumn);
        if (mappedRowObject instanceof Address) {
            return (Address)mappedRowObject;
        }
        return null;
    }

    public Address getAddress(int modelRow) {
        Object rowObject = this.filteredData.get(modelRow);
        if (rowObject instanceof Address) {
            return (Address)rowObject;
        }
        return null;
    }

    private Object getMappedRowObject(DynamicTableColumn<ROW_TYPE, ?, ?> tableColumn, ROW_TYPE currentRowObject, int columnIndex) {
        if (tableColumn instanceof MappedTableColumn) {
            MappedTableColumn mappedColumn = (MappedTableColumn)tableColumn;
            return mappedColumn.map(currentRowObject, (Object)this.getProgram(), this.serviceProvider);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int modelRow, int modelColumn) {
        ProgramLocationTableColumn programField;
        ProgramLocation loc;
        if (modelRow < 0 || modelRow >= this.filteredData.size()) {
            return null;
        }
        Object rowObject = this.filteredData.get(modelRow);
        DynamicTableColumn tableColumn = this.getColumn(modelColumn);
        if (tableColumn instanceof ProgramLocationTableColumn && (loc = (programField = (ProgramLocationTableColumn)tableColumn).getProgramLocation(rowObject, this.getColumnSettings(modelColumn), this.getProgram(), this.serviceProvider)) != null) {
            return loc;
        }
        Address address = this.getAddress(modelRow, modelColumn);
        if (address != null) {
            return new ProgramLocation(this.getProgram(), address);
        }
        return null;
    }

    @Override
    public ProgramSelection getProgramSelection(int[] modelRows) {
        AddressSet addressSet = new AddressSet();
        for (int element : modelRows) {
            Address addr = this.getAddress(element);
            if (!addr.isMemoryAddress()) continue;
            addressSet.addRange(addr, addr);
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }
}

