/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourceMapEntry;
import ghidra.util.BigEndianDataConverter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HexFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SourceFileUtils {
    private static HexFormat hexFormat = HexFormat.of();
    private static Pattern dirNameValidator = Pattern.compile("\\W");

    private SourceFileUtils() {
    }

    public static SourceFile getSourceFileFromPathString(String path) {
        return SourceFileUtils.getSourceFileFromPathString(path, SourceFileIdType.NONE, null);
    }

    public static SourceFile getSourceFileFromPathString(String path, SourceFileIdType idType, byte[] identifier) {
        String standardized = FSUtilities.normalizeNativePath(path);
        return new SourceFile(standardized, idType, identifier);
    }

    public static byte[] longToByteArray(long l) {
        byte[] bytes = new byte[8];
        BigEndianDataConverter.INSTANCE.putLong(bytes, 0, l);
        return bytes;
    }

    public static long byteArrayToLong(byte[] bytes) {
        if (bytes.length != 8) {
            throw new IllegalArgumentException("bytes must have length 8");
        }
        return BigEndianDataConverter.INSTANCE.getLong(bytes);
    }

    public static byte[] hexStringToByteArray(String hexString) {
        if (StringUtils.isBlank((CharSequence)hexString)) {
            return new byte[0];
        }
        if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
            hexString = hexString.substring(2);
        }
        return hexFormat.parseHex(hexString);
    }

    public static String byteArrayToHexString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return hexFormat.formatHex(bytes);
    }

    public static SourceLineBounds getSourceLineBounds(Program program, SourceFile sourceFile) {
        List entries = program.getSourceFileManager().getSourceMapEntries(sourceFile, 0, Integer.MAX_VALUE);
        if (entries.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        int max = -1;
        for (SourceMapEntry entry : entries) {
            int lineNum = entry.getLineNumber();
            if (lineNum < min) {
                min = lineNum;
            }
            if (lineNum <= max) continue;
            max = lineNum;
        }
        return new SourceLineBounds(min, max);
    }

    public static String normalizeDwarfPath(String path, String baseDir) {
        if (StringUtils.isEmpty((CharSequence)baseDir)) {
            throw new IllegalArgumentException("baseDir cannot be empty");
        }
        Matcher matcher = dirNameValidator.matcher(baseDir);
        if (matcher.find()) {
            throw new IllegalArgumentException("baseDir must consist of alphanumeric characters or underscores");
        }
        boolean based = false;
        if (((String)path).startsWith("./")) {
            path = "/" + baseDir + ((String)path).substring(1);
            based = true;
        }
        path = FSUtilities.normalizeNativePath((String)path);
        try {
            URI uri = new URI("file", null, (String)path, null).normalize();
            path = uri.getPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("path not valid: " + e.getMessage());
        }
        int numDotDots = 0;
        while (((String)path).startsWith("/..")) {
            path = ((String)path).substring(3);
            ++numDotDots;
        }
        if (numDotDots == 0) {
            if (!based) {
                return path;
            }
            if (((String)path).startsWith("/" + baseDir)) {
                return path;
            }
        }
        if (based) {
            ++numDotDots;
        }
        String count = numDotDots == 0 ? "" : "_" + Integer.toString(numDotDots);
        return "/" + baseDir + count + (String)path;
    }

    public record SourceLineBounds(int min, int max) {
        public SourceLineBounds {
            if (min < 0) {
                throw new IllegalArgumentException("min must be greater than or equal to 0");
            }
            if (max < 0) {
                throw new IllegalArgumentException("max must be greater than or equal to 0");
            }
            if (max < min) {
                throw new IllegalArgumentException("max must be greater than or equal to min");
            }
        }
    }
}

