/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.values;

import docking.widgets.button.BrowseButton;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

abstract class AbstractProjectBrowserPanel
extends JPanel {
    protected Project project;
    protected JTextField textField;
    private JButton browseButton;
    private DomainFolder startFolder;
    private DataTreeDialogType type;
    protected DomainFileFilter filter = null;

    AbstractProjectBrowserPanel(DataTreeDialogType type, Project project, String name, String startPath) {
        super(new BorderLayout());
        this.type = type;
        this.project = Objects.requireNonNull(project);
        this.startFolder = AbstractProjectBrowserPanel.parseDomainFolder(project, startPath);
        this.setName(name);
        this.textField = new JTextField(20);
        this.browseButton = new BrowseButton();
        this.browseButton.addActionListener(e -> this.showProjectChooser());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.browseButton, "East");
    }

    private void showProjectChooser() {
        DataTreeDialog dialog = new DataTreeDialog(null, "Choose " + this.getName(), this.type, this.filter, this.project);
        if (this.startFolder != null) {
            dialog.selectFolder(this.startFolder);
        }
        this.intializeCurrentValue(dialog);
        dialog.show();
        if (dialog.wasCancelled()) {
            return;
        }
        String text = this.getSelectedPath(dialog);
        this.textField.setText(text);
        dialog.dispose();
    }

    protected abstract String getSelectedPath(DataTreeDialog var1);

    protected abstract void intializeCurrentValue(DataTreeDialog var1);

    String getText() {
        return this.textField.getText().trim();
    }

    static DomainFile parseDomainFile(Project project, String val) {
        DomainFile df;
        if (!((String)val).isEmpty() && ((String)val).charAt(0) != '/') {
            val = "/" + (String)val;
        }
        if ((df = project.getProjectData().getFile((String)val)) != null) {
            return df;
        }
        return null;
    }

    static DomainFolder parseDomainFolder(Project project, String path) {
        DomainFolder df;
        if (path == null) {
            return null;
        }
        if (((String)(path = ((String)path).trim())).isEmpty() || ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        if ((df = project.getProjectData().getFolder((String)path)) != null) {
            return df;
        }
        return null;
    }
}

