/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.handler;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.replace.SearchAndReplaceHandler;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.features.base.replace.SearchType;
import ghidra.features.base.replace.items.RenameDataTypeQuickFix;
import ghidra.features.base.replace.items.RenameEnumValueQuickFix;
import ghidra.features.base.replace.items.RenameFieldQuickFix;
import ghidra.features.base.replace.items.UpdateDataTypeDescriptionQuickFix;
import ghidra.features.base.replace.items.UpdateEnumCommentQuickFix;
import ghidra.features.base.replace.items.UpdateFieldCommentQuickFix;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypesSearchAndReplaceHandler
extends SearchAndReplaceHandler {
    DataTypeSearchType nameType = new NameSearchType(this);
    DataTypeSearchType datatypeCommentsType = new DataTypeCommentsSearchType(this);
    DataTypeSearchType fieldNameType = new FieldNameSearchType(this);
    DataTypeSearchType enumValueNameType = new EnumValueSearchType(this);

    public DataTypesSearchAndReplaceHandler() {
        this.addType(this.nameType);
        this.addType(this.datatypeCommentsType);
        this.addType(this.fieldNameType);
        this.addType(this.enumValueNameType);
    }

    @Override
    public void findAll(Program program, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        ArrayList allDataTypes = new ArrayList();
        dataTypeManager.getAllDataTypes(allDataTypes);
        monitor.initialize((long)allDataTypes.size(), "Searching DataTypes...");
        boolean doNames = query.containsSearchType(this.nameType);
        boolean doDatatypeComments = query.containsSearchType(this.datatypeCommentsType);
        boolean doFieldNames = query.containsSearchType(this.fieldNameType);
        boolean doEnumValueNames = query.containsSearchType(this.enumValueNameType);
        for (DataType dataType : allDataTypes) {
            monitor.increment();
            if (dataType instanceof Pointer || dataType instanceof Array) continue;
            if (doNames) {
                this.nameType.search(program, dataType, query, accumulator);
            }
            if (doDatatypeComments) {
                this.datatypeCommentsType.search(program, dataType, query, accumulator);
            }
            if (doFieldNames) {
                this.fieldNameType.search(program, dataType, query, accumulator);
            }
            if (!doEnumValueNames) continue;
            this.enumValueNameType.search(program, dataType, query, accumulator);
        }
    }

    private static class NameSearchType
    extends DataTypeSearchType {
        public NameSearchType(SearchAndReplaceHandler handler) {
            super(handler, "Datatypes", "Search and replace datatype names");
        }

        @Override
        protected void search(Program program, DataType dataType, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator) {
            Pattern searchPattern = query.getSearchPattern();
            Matcher matcher = searchPattern.matcher(dataType.getName());
            if (matcher.find()) {
                String newName = matcher.replaceAll(query.getReplacementText());
                RenameDataTypeQuickFix item = new RenameDataTypeQuickFix(program, dataType, newName);
                accumulator.add((Object)item);
            }
        }
    }

    private static abstract class DataTypeSearchType
    extends SearchType {
        public DataTypeSearchType(SearchAndReplaceHandler handler, String name, String description) {
            super(handler, name, description);
        }

        protected abstract void search(Program var1, DataType var2, SearchAndReplaceQuery var3, Accumulator<QuickFix> var4);
    }

    private static class DataTypeCommentsSearchType
    extends DataTypeSearchType {
        public DataTypeCommentsSearchType(SearchAndReplaceHandler handler) {
            super(handler, "Datatype Comments", "Search and replace comments on datatypes");
        }

        @Override
        protected void search(Program program, DataType dataType, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator) {
            this.searchDescriptions(program, dataType, query, accumulator);
            if (dataType instanceof Composite) {
                Composite composite = (Composite)dataType;
                this.searchFieldComments(program, composite, query, accumulator);
            } else if (dataType instanceof Enum) {
                Enum enumm = (Enum)dataType;
                this.searchEnumComments(program, enumm, query, accumulator);
            }
        }

        private void searchEnumComments(Program program, Enum enumm, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator) {
            String[] names = enumm.getNames();
            Pattern searchPattern = query.getSearchPattern();
            for (int i = 0; i < names.length; ++i) {
                String valueName = names[i];
                String comment = enumm.getComment(valueName);
                Matcher matcher = searchPattern.matcher(comment);
                if (!matcher.find()) continue;
                String newValueName = matcher.replaceAll(query.getReplacementText());
                UpdateEnumCommentQuickFix item = new UpdateEnumCommentQuickFix(program, enumm, valueName, newValueName);
                accumulator.add((Object)item);
            }
        }

        private void searchFieldComments(Program program, Composite composite, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator) {
            DataTypeComponent[] definedComponents = composite.getDefinedComponents();
            Pattern searchPattern = query.getSearchPattern();
            for (int i = 0; i < definedComponents.length; ++i) {
                Matcher matcher;
                DataTypeComponent component = definedComponents[i];
                String comment = component.getComment();
                if (comment == null || !(matcher = searchPattern.matcher(comment)).find()) continue;
                String newComment = matcher.replaceAll(query.getReplacementText());
                UpdateFieldCommentQuickFix item = new UpdateFieldCommentQuickFix(program, composite, component.getFieldName(), component.getOrdinal(), comment, newComment);
                accumulator.add((Object)item);
            }
        }

        protected void searchDescriptions(Program program, DataType dataType, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator) {
            String description = this.getDescription(dataType);
            if (description == null || description.isBlank()) {
                return;
            }
            Pattern searchPattern = query.getSearchPattern();
            Matcher matcher = searchPattern.matcher(description);
            if (matcher.find()) {
                String newName = matcher.replaceAll(query.getReplacementText());
                UpdateDataTypeDescriptionQuickFix item = new UpdateDataTypeDescriptionQuickFix(program, dataType, newName);
                accumulator.add((Object)item);
            }
        }

        private String getDescription(DataType dataType) {
            if (dataType instanceof Composite) {
                Composite composite = (Composite)dataType;
                return composite.getDescription();
            }
            if (dataType instanceof Enum) {
                Enum enumDataType = (Enum)dataType;
                return enumDataType.getDescription();
            }
            return null;
        }
    }

    private static class FieldNameSearchType
    extends DataTypeSearchType {
        public FieldNameSearchType(SearchAndReplaceHandler handler) {
            super(handler, "Datatype Fields", "Search and replace structure and union member names");
        }

        @Override
        protected void search(Program program, DataType dataType, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator) {
            if (!(dataType instanceof Composite)) {
                return;
            }
            Composite composite = (Composite)dataType;
            DataTypeComponent[] definedComponents = composite.getDefinedComponents();
            Pattern searchPattern = query.getSearchPattern();
            for (int i = 0; i < definedComponents.length; ++i) {
                DataTypeComponent component = definedComponents[i];
                String name = this.getFieldName(component);
                Matcher matcher = searchPattern.matcher(name);
                if (!matcher.find()) continue;
                String newName = matcher.replaceAll(query.getReplacementText());
                int ordinal = component.getOrdinal();
                RenameFieldQuickFix item = new RenameFieldQuickFix(program, composite, ordinal, name, newName);
                accumulator.add((Object)item);
            }
        }

        private String getFieldName(DataTypeComponent component) {
            String fieldName = component.getFieldName();
            return fieldName == null ? component.getDefaultFieldName() : fieldName;
        }
    }

    private static class EnumValueSearchType
    extends DataTypeSearchType {
        public EnumValueSearchType(SearchAndReplaceHandler handler) {
            super(handler, "Enum Values", "Search and replace enum value names");
        }

        @Override
        protected void search(Program program, DataType dataType, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator) {
            if (!(dataType instanceof Enum)) {
                return;
            }
            Enum enumm = (Enum)dataType;
            String[] names = enumm.getNames();
            Pattern searchPattern = query.getSearchPattern();
            for (int i = 0; i < names.length; ++i) {
                String valueName = names[i];
                Matcher matcher = searchPattern.matcher(valueName);
                if (!matcher.find()) continue;
                String newValueName = matcher.replaceAll(query.getReplacementText());
                RenameEnumValueQuickFix item = new RenameEnumValueQuickFix(program, enumm, valueName, newValueName);
                accumulator.add((Object)item);
            }
        }
    }
}

